/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.RefValidator;
import com.networknt.schema.RequiredValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneOfValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RequiredValidator.class);
    private List<ShortcutValidator> schemas = new ArrayList<ShortcutValidator>();

    public OneOfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ONE_OF, validationContext);
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            JsonNode childNode = schemaNode.get(i);
            JsonSchema childSchema = new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUrl(), childNode, parentSchema);
            this.schemas.add(new ShortcutValidator(childNode, parentSchema, validationContext, childSchema));
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        boolean missingNodeAsError = this.config.isMissingNodeAsError();
        this.config.setMissingNodeAsError(true);
        int numberOfValidSchema = 0;
        Set<Object> errors = new LinkedHashSet<ValidationMessage>();
        for (ShortcutValidator validator : this.schemas) {
            if (!validator.allConstantsMatch(node)) continue;
            JsonSchema schema = validator.schema;
            Set<ValidationMessage> schemaErrors = schema.validate(node, rootNode, at);
            if (schemaErrors.isEmpty()) {
                ++numberOfValidSchema;
                errors = new LinkedHashSet();
            }
            if (numberOfValidSchema != 0) continue;
            if (this.config.hasElementValidationError()) {
                errors.clear();
                errors.addAll(schemaErrors);
                break;
            }
            errors.addAll(schemaErrors);
        }
        if (numberOfValidSchema == 0) {
            Iterator it = errors.iterator();
            while (it.hasNext()) {
                ValidationMessage msg = (ValidationMessage)it.next();
                if (!ValidatorTypeCode.ADDITIONAL_PROPERTIES.getValue().equals(msg.getType())) continue;
                it.remove();
            }
            if (errors.isEmpty()) {
                errors.add(this.buildValidationMessage(at, ""));
            }
        }
        if (numberOfValidSchema > 1) {
            errors = Collections.singleton(this.buildValidationMessage(at, ""));
        }
        this.config.setMissingNodeAsError(missingNodeAsError);
        return Collections.unmodifiableSet(errors);
    }

    private static class ShortcutValidator {
        private final JsonSchema schema;
        private final Map<String, String> constants;

        ShortcutValidator(JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, JsonSchema schema) {
            JsonNode refNode = schemaNode.get(ValidatorTypeCode.REF.getValue());
            JsonSchema resolvedRefSchema = refNode != null && refNode.isTextual() ? RefValidator.getRefSchema(parentSchema, validationContext, refNode.textValue()) : null;
            this.constants = this.extractConstants(schemaNode, resolvedRefSchema);
            this.schema = schema;
        }

        private Map<String, String> extractConstants(JsonNode schemaNode, JsonSchema resolvedRefSchema) {
            Map<String, String> refMap = resolvedRefSchema != null ? this.extractConstants(resolvedRefSchema.getSchemaNode()) : Collections.emptyMap();
            Map<String, String> schemaMap = this.extractConstants(schemaNode);
            if (refMap.isEmpty()) {
                return schemaMap;
            }
            if (schemaMap.isEmpty()) {
                return refMap;
            }
            HashMap<String, String> joined = new HashMap<String, String>();
            joined.putAll(schemaMap);
            joined.putAll(refMap);
            return joined;
        }

        private Map<String, String> extractConstants(JsonNode schemaNode) {
            HashMap<String, String> result = new HashMap<String, String>();
            if (!schemaNode.isObject()) {
                return result;
            }
            JsonNode propertiesNode = schemaNode.get("properties");
            if (propertiesNode == null || !propertiesNode.isObject()) {
                return result;
            }
            Iterator fit = propertiesNode.fieldNames();
            while (fit.hasNext()) {
                String fieldName = (String)fit.next();
                JsonNode jsonNode = propertiesNode.get(fieldName);
                String constantFieldValue = this.getConstantFieldValue(jsonNode);
                if (constantFieldValue == null || constantFieldValue.isEmpty()) continue;
                result.put(fieldName, constantFieldValue);
            }
            return result;
        }

        private String getConstantFieldValue(JsonNode jsonNode) {
            if (jsonNode == null || !jsonNode.isObject() || !jsonNode.has("enum")) {
                return null;
            }
            JsonNode enumNode = jsonNode.get("enum");
            if (enumNode == null || !enumNode.isArray()) {
                return null;
            }
            if (enumNode.size() != 1) {
                return null;
            }
            JsonNode valueNode = enumNode.get(0);
            if (valueNode == null || !valueNode.isTextual()) {
                return null;
            }
            return valueNode.textValue();
        }

        public boolean allConstantsMatch(JsonNode node) {
            for (Map.Entry<String, String> e : this.constants.entrySet()) {
                boolean match;
                JsonNode valueNode = node.get(e.getKey());
                if (valueNode == null || !valueNode.isTextual() || (match = e.getValue().equals(valueNode.textValue()))) continue;
                return false;
            }
            return true;
        }
    }
}

