/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CustomErrorMessageType;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.url.URLFactory;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RefValidator.class);
    protected JsonSchema schema;
    private static final String REF_DOMAIN = "/";
    private static final String REF_CURRENT = "#";
    private static final String REF_RELATIVE = "../";

    public RefValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.REF, validationContext);
        String refValue = schemaNode.asText();
        this.schema = RefValidator.getRefSchema(parentSchema, validationContext, refValue);
        if (this.schema == null) {
            throw new JsonSchemaException(ValidationMessage.of(ValidatorTypeCode.REF.getValue(), CustomErrorMessageType.of("internal.unresolvedRef", new MessageFormat("{0}: Reference {1} cannot be resolved")), schemaPath, refValue));
        }
    }

    static JsonSchema getRefSchema(JsonSchema parentSchema, ValidationContext validationContext, String refValue) {
        if (!refValue.startsWith(REF_CURRENT)) {
            String schemaUrl = refValue;
            int index = refValue.indexOf(REF_CURRENT);
            if (index > 0) {
                schemaUrl = schemaUrl.substring(0, index);
            }
            if (RefValidator.isRelativePath(schemaUrl)) {
                schemaUrl = RefValidator.obtainAbsolutePath(parentSchema, schemaUrl);
            }
            try {
                URL url = URLFactory.toURL(schemaUrl);
                parentSchema = validationContext.getJsonSchemaFactory().getSchema(url, validationContext.getConfig());
            }
            catch (MalformedURLException e) {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(schemaUrl);
                parentSchema = validationContext.getJsonSchemaFactory().getSchema(is);
            }
            if (index < 0) {
                return parentSchema.findAncestor();
            }
            refValue = refValue.substring(index);
        }
        if (refValue.equals(REF_CURRENT)) {
            return parentSchema.findAncestor();
        }
        JsonNode node = parentSchema.getRefSchemaNode(refValue);
        if (node != null) {
            return new JsonSchema(validationContext, refValue, node, parentSchema);
        }
        return null;
    }

    private static boolean isRelativePath(String schemaUrl) {
        return !schemaUrl.startsWith("http");
    }

    private static String obtainAbsolutePath(JsonSchema parentSchema, String schemaUrl) {
        String baseSchemaUrl = parentSchema.findAncestor().getSchemaNode().get("id").textValue();
        int index = baseSchemaUrl.lastIndexOf(REF_DOMAIN);
        baseSchemaUrl = baseSchemaUrl.substring(0, index);
        String schemaRef = schemaUrl;
        if (schemaRef.startsWith(REF_DOMAIN)) {
            try {
                URL url = URLFactory.toURL(baseSchemaUrl);
                baseSchemaUrl = url.getProtocol() + "//" + url.getHost();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else if (schemaRef.startsWith(REF_RELATIVE)) {
            while (schemaRef.startsWith(REF_RELATIVE)) {
                index = baseSchemaUrl.lastIndexOf(REF_DOMAIN);
                baseSchemaUrl = baseSchemaUrl.substring(0, index);
                schemaRef = schemaRef.replaceFirst(REF_RELATIVE, "");
            }
        }
        schemaRef = baseSchemaUrl + REF_DOMAIN + schemaRef;
        return schemaRef;
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (this.schema != null) {
            return this.schema.validate(node, rootNode, at);
        }
        return Collections.emptySet();
    }
}

