/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleOfValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(MultipleOfValidator.class);
    private double divisor = 0.0;

    public MultipleOfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ObjectMapper mapper) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.MULTIPLE_OF);
        if (schemaNode.isNumber()) {
            this.divisor = schemaNode.doubleValue();
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        HashSet<ValidationMessage> errors = new HashSet<ValidationMessage>();
        if (node.isNumber()) {
            long multiples;
            double nodeValue = node.doubleValue();
            if (this.divisor != 0.0 && Math.abs((double)(multiples = Math.round(nodeValue / this.divisor)) * this.divisor - nodeValue) > 1.0E-12) {
                errors.add(this.buildValidationMessage(at, "" + this.divisor));
            }
        }
        return errors;
    }
}

