/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.url;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

class ClasspathURLStreamHandler
extends URLStreamHandler {
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String RESOURCE_PREFIX = "resource:";

    ClasspathURLStreamHandler() {
    }

    boolean supports(String pURL) {
        return pURL.startsWith(CLASSPATH_PREFIX) || pURL.startsWith(RESOURCE_PREFIX);
    }

    @Override
    protected URLConnection openConnection(URL pURL) throws IOException {
        return new ClassPathURLConnection(pURL);
    }

    class ClassPathURLConnection
    extends URLConnection {
        private Class<?> mHost;

        protected ClassPathURLConnection(URL pURL) {
            super(pURL);
            this.mHost = null;
        }

        @Override
        public final void connect() throws IOException {
            String className = this.url.getHost();
            try {
                if (className != null && className.length() > 0) {
                    this.mHost = Class.forName(className);
                }
                this.connected = true;
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Class not found: " + e.toString());
            }
        }

        @Override
        public final InputStream getInputStream() throws IOException {
            if (!this.connected) {
                this.connect();
            }
            return this.getResourceAsStream(this.url);
        }

        private InputStream getResourceAsStream(URL pURL) throws IOException {
            InputStream stream;
            String path = pURL.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (this.mHost != null) {
                stream = this.mHost.getClassLoader().getResourceAsStream(path);
            } else {
                stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
                if (stream == null) {
                    stream = this.getClass().getClassLoader().getResourceAsStream(path);
                }
                if (stream == null) {
                    stream = ClassLoader.getSystemResourceAsStream(path);
                }
            }
            if (stream == null) {
                throw new IOException("Resource " + path + " not found in classpath.");
            }
            return stream;
        }
    }
}

