/*
 * Decompiled with CFR 0.152.
 */
package com.networkingx.okhttpclient;

import com.networkingx.client.Client;
import com.networkingx.internal.Generic;
import com.networkingx.log.Logger;
import com.networkingx.policies.RetryPolicy;
import com.networkingx.request.ContentType;
import com.networkingx.request.RequestBody;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0005B\u0011\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010\u0013\u001a\u00020\u00102\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J`\u0010\u0018\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2&\u0010\u001c\u001a\"\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00190\u001e\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u001dj\n\u0012\u0004\u0012\u0002H\u0019\u0018\u0001`\u001f2 \u0010 \u001a\u001c\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0010\u0018\u00010!j\u0004\u0018\u0001`#H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/networkingx/okhttpclient/OkHttpClient;", "Lcom/networkingx/client/Client;", "retryPolicy", "Lcom/networkingx/policies/RetryPolicy;", "(Lcom/networkingx/policies/RetryPolicy;)V", "()V", "client", "Lokhttp3/OkHttpClient;", "(Lokhttp3/OkHttpClient;)V", "canHandleRequest", "", "url", "", "method", "", "cancelAllRequests", "", "cancelPendingRequests", "tag", "createClient", "getRequestBody", "Lokhttp3/RequestBody;", "requestBody", "Lcom/networkingx/request/RequestBody;", "makeRequest", "F", "request", "Lcom/networkingx/request/Request;", "onSuccess", "Lkotlin/Function1;", "Lcom/networkingx/response/Response;", "Lcom/networkingx/response/OnSuccess;", "onError", "Lkotlin/Function2;", "", "Lcom/networkingx/response/OnError;", "Companion", "okHttpClient_release"})
public final class OkHttpClient
extends Client {
    private okhttp3.OkHttpClient client;
    @NotNull
    private static final MediaType JSON;
    @NotNull
    private static final MediaType STRING;
    public static final Companion Companion;

    private final void createClient(RetryPolicy retryPolicy) {
        this.client = new OkHttpClient.Builder().connectTimeout((long)retryPolicy.getCurrentTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)retryPolicy.getCurrentTimeout(), TimeUnit.MILLISECONDS).addInterceptor(new Interceptor(retryPolicy){
            final /* synthetic */ RetryPolicy $retryPolicy;

            @NotNull
            public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
                Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
                Request request = chain.request();
                Response response = chain.proceed(request);
                for (int tryCount = 0; !response.isSuccessful() && tryCount < this.$retryPolicy.getRetryCount(); ++tryCount) {
                    Logger.INSTANCE.w("intercept", "Request is not successful - " + tryCount);
                    Request.Builder requestBuilder = request.newBuilder().headers(request.headers()).method(request.method(), request.body());
                    Request newRequest = requestBuilder.build();
                    response = chain.proceed(newRequest);
                }
                return response;
            }
            {
                this.$retryPolicy = $captured_local_variable$0;
            }
        }).build();
    }

    static /* synthetic */ void createClient$default(OkHttpClient okHttpClient, RetryPolicy retryPolicy, int n, Object object) {
        if ((n & 1) != 0) {
            retryPolicy = okHttpClient.getRetryPolicy();
        }
        okHttpClient.createClient(retryPolicy);
    }

    public boolean canHandleRequest(@NotNull String url, int method) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        return method != 5 && method != 6;
    }

    /*
     * WARNING - void declaration
     */
    public <F> void makeRequest(@NotNull com.networkingx.request.Request request, @Nullable Function1<? super com.networkingx.response.Response<F>, Unit> onSuccess, @Nullable Function2<? super Throwable, ? super Integer, Unit> onError) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Logger.INSTANCE.d("Client", "Tag:" + request.getRequestData().getReqTAG());
        Logger.INSTANCE.d("Client", request.getRequestData().getReqTAG() + " request Url: " + request.getRequestData().getRequestUrl());
        Logger.INSTANCE.d("Client", request.getRequestData().getReqTAG() + " request Json Params: " + request.getRequestData().getRequestBody().getBody());
        Logger.INSTANCE.d("Client", request.getRequestData().getReqTAG() + " request Header: " + request.getRequestData().getRequestHeader());
        Request.Builder builder = new Request.Builder().url(request.getRequestData().getRequestUrl()).tag((Object)request.getRequestData().getReqTAG());
        HashMap hashMap = request.getRequestData().getRequestHeader();
        if (hashMap != null) {
            HashMap hashMap2 = hashMap;
            boolean bl2 = false;
            bl = false;
            HashMap $this$apply = hashMap2;
            boolean bl3 = false;
            Object object = $this$apply;
            boolean bl4 = false;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void key1;
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                boolean bl5 = false;
                object = (String)entry2.getKey();
                entry2 = entry;
                bl5 = false;
                String value = (String)entry2.getValue();
                String string = value;
                if (string == null) {
                    string = "";
                }
                builder.addHeader((String)key1, string);
            }
        }
        okhttp3.RequestBody requestBody = this.getRequestBody(request.getRequestData().getRequestBody());
        switch (request.getRequestData().getMethod()) {
            case 0: {
                builder.get();
                break;
            }
            case 1: {
                builder.post(requestBody);
                break;
            }
            case 3: {
                builder.delete(requestBody);
                break;
            }
            case 4: {
                builder.head();
                break;
            }
            case 7: {
                builder.patch(requestBody);
                break;
            }
            case 2: {
                builder.put(requestBody);
                break;
            }
            case 5: {
                throw (Throwable)new IllegalArgumentException("okHttp does not support Options request type, Use volley request Manager for this type of request");
            }
            case 6: {
                throw (Throwable)new IllegalArgumentException("okHttp does not support trace request type, Use volley request Manager for this type of request");
            }
        }
        RetryPolicy retryPolicy = request.getRetryPolicy();
        if (retryPolicy != null) {
            RetryPolicy retryPolicy2 = retryPolicy;
            bl = false;
            boolean bl6 = false;
            RetryPolicy it = retryPolicy2;
            boolean bl7 = false;
            this.createClient(it);
        }
        okhttp3.OkHttpClient okHttpClient = this.client;
        if (okHttpClient == null) {
            Intrinsics.throwNpe();
        }
        okHttpClient.newCall(builder.build()).enqueue(new Callback(request, onError, onSuccess){
            final /* synthetic */ com.networkingx.request.Request $request;
            final /* synthetic */ Function2 $onError;
            final /* synthetic */ Function1 $onSuccess;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    Logger.INSTANCE.e("Client", this.$request.getRequestData().getReqTAG() + " onErrorResponse >> errorCode: " + 110);
                    Function2 function2 = this.$onError;
                    if (function2 == null) break block0;
                    Unit cfr_ignored_0 = (Unit)function2.invoke((Object)new NullPointerException("unknown error"), (Object)110);
                }
            }

            /*
             * Unable to fully structure code
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                block11: {
                    Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                    if (!response.isSuccessful()) {
                        Logger.INSTANCE.e("Client", this.$request.getRequestData().getReqTAG() + " onErrorResponse >> errorCode: " + response.code());
                        v0 = this.$onError;
                        if (v0 != null) {
                            (Unit)v0.invoke((Object)new NullPointerException("failed response"), (Object)response.code());
                        }
                        return;
                    }
                    body = response.body();
                    if (body == null) {
                        Logger.INSTANCE.e("Client", "onResponse jsonObject: null");
                        v1 = this.$onError;
                        if (v1 != null) {
                            (Unit)v1.invoke((Object)new NullPointerException("null response"), (Object)117);
                        }
                        return;
                    }
                    responseHeaders = response.headers();
                    headers = null;
                    headers = new HashMap<K, V>(responseHeaders.size());
                    size = responseHeaders.size();
                    for (i = 0; i < size; ++i) {
                        ((Map)headers).put(responseHeaders.name(i), responseHeaders.value(i));
                    }
                    responseValue = null;
                    if (this.$onSuccess == null) {
                        return;
                    }
                    try {
                        block14: {
                            block22: {
                                block21: {
                                    block20: {
                                        block19: {
                                            block18: {
                                                block17: {
                                                    block16: {
                                                        block15: {
                                                            block13: {
                                                                block12: {
                                                                    this_$iv = Generic.Companion;
                                                                    $i$f$invoke = false;
                                                                    if (new Generic(Function1.class).checkType((Object)this.$onSuccess)) break block12;
                                                                    this_$iv = Generic.Companion;
                                                                    $i$f$invoke = false;
                                                                    if (!new Generic(Function1.class).checkType((Object)this.$onSuccess)) break block13;
                                                                }
                                                                responseValue = body.string();
                                                                break block14;
                                                            }
                                                            this_$iv = Generic.Companion;
                                                            $i$f$invoke = false;
                                                            if (new Generic(Function1.class).checkType((Object)this.$onSuccess)) break block15;
                                                            this_$iv = Generic.Companion;
                                                            $i$f$invoke = false;
                                                            if (!new Generic(Function1.class).checkType((Object)this.$onSuccess)) break block16;
                                                        }
                                                        responseValue = body.bytes();
                                                        break block14;
                                                    }
                                                    this_$iv = Generic.Companion;
                                                    $i$f$invoke = false;
                                                    if (new Generic(Function1.class).checkType((Object)this.$onSuccess)) break block17;
                                                    this_$iv = Generic.Companion;
                                                    $i$f$invoke = false;
                                                    if (!new Generic(Function1.class).checkType((Object)this.$onSuccess)) break block18;
                                                }
                                                responseValue = body.byteString();
                                                break block14;
                                            }
                                            this_$iv = Generic.Companion;
                                            $i$f$invoke = false;
                                            if (new Generic(Function1.class).checkType((Object)this.$onSuccess)) break block19;
                                            this_$iv = Generic.Companion;
                                            $i$f$invoke = false;
                                            if (!new Generic(Function1.class).checkType((Object)this.$onSuccess)) break block20;
                                        }
                                        responseValue = body.byteStream();
                                        break block14;
                                    }
                                    this_$iv = Generic.Companion;
                                    $i$f$invoke = false;
                                    if (new Generic(Function1.class).checkType((Object)this.$onSuccess)) break block21;
                                    this_$iv = Generic.Companion;
                                    $i$f$invoke = false;
                                    if (!new Generic(Function1.class).checkType((Object)this.$onSuccess)) break block22;
                                }
                                responseValue = body.charStream();
                                break block14;
                            }
                            this_$iv = Generic.Companion;
                            $i$f$invoke = false;
                            if (new Generic(Function1.class).checkType((Object)this.$onSuccess)) ** GOTO lbl-1000
                            this_$iv = Generic.Companion;
                            $i$f$invoke = false;
                            if (new Generic(Function1.class).checkType((Object)this.$onSuccess)) lbl-1000:
                            // 2 sources

                            {
                                this_$iv = body.source();
                                var10_11 = false;
                                var11_12 = false;
                                $this$apply = this_$iv;
                                $i$a$-apply-OkHttpClient$makeRequest$3$onResponse$1 = false;
                                $this$apply.close();
                                responseValue = this_$iv;
                            } else {
                                v2 = this.$onError;
                                if (v2 != null) {
                                    (Unit)v2.invoke((Object)new ParseException("unexpected response format", 0), (Object)116);
                                }
                            }
                        }
                        Logger.INSTANCE.d("Client", "onResponse jsonObject: " + String.valueOf(responseValue));
                        this.$onSuccess.invoke((Object)new com.networkingx.response.Response(responseValue, (Map)headers, response.code(), response.receivedResponseAtMillis() - response.sentRequestAtMillis(), 2));
                    }
                    catch (JSONException e) {
                        Logger.INSTANCE.e("Client", this.$request.getRequestData().getReqTAG() + " onErrorResponse >> errorCode: " + 116);
                        e.printStackTrace();
                        v3 = this.$onError;
                        if (v3 == null) break block11;
                        (Unit)v3.invoke((Object)new ParseException("unexpected response format", 0), (Object)116);
                    }
                }
            }
            {
                this.$request = $captured_local_variable$0;
                this.$onError = $captured_local_variable$1;
                this.$onSuccess = $captured_local_variable$2;
            }
        });
    }

    public void cancelPendingRequests(@Nullable String tag) {
        okhttp3.OkHttpClient okHttpClient = this.client;
        if (okHttpClient == null) {
            Intrinsics.throwNpe();
        }
        List calls = okHttpClient.dispatcher().queuedCalls();
        for (Call call : calls) {
            if (!Intrinsics.areEqual((Object)call.request().tag(), (Object)tag) || call.isCanceled()) continue;
            call.cancel();
        }
    }

    public void cancelAllRequests() {
        okhttp3.OkHttpClient okHttpClient = this.client;
        if (okHttpClient == null) {
            Intrinsics.throwNpe();
        }
        okHttpClient.dispatcher().cancelAll();
    }

    private final okhttp3.RequestBody getRequestBody(RequestBody requestBody) {
        okhttp3.RequestBody requestBody2;
        CharSequence charSequence = requestBody.getBody();
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            String string = requestBody.getBody();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            requestBody2 = okhttp3.RequestBody.Companion.create(string, MediaType.Companion.get(requestBody.getMediaType()));
        } else if (requestBody.getBodyParams() != null && requestBody.getEncodedBodyParams() != null) {
            String key;
            String value;
            boolean bl3;
            Map.Entry entry;
            FormBody.Builder builder = new FormBody.Builder(null, 1, null);
            HashMap hashMap = requestBody.getBodyParams();
            if (hashMap == null) {
                Intrinsics.throwNpe();
            }
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry2;
                entry = entry2 = iterator.next();
                bl3 = false;
                String string = (String)entry.getKey();
                entry = entry2;
                bl3 = false;
                value = (String)entry.getValue();
                void v3 = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"key");
                String string2 = value;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"value");
                builder.add((String)v3, string2);
            }
            HashMap hashMap2 = requestBody.getEncodedBodyParams();
            if (hashMap2 == null) {
                Intrinsics.throwNpe();
            }
            for (Map.Entry entry3 : hashMap2.entrySet()) {
                entry = entry3;
                bl3 = false;
                key = (String)entry.getKey();
                entry = entry3;
                bl3 = false;
                value = (String)entry.getValue();
                String string = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
                String string3 = value;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"value");
                builder.addEncoded(string, string3);
            }
            requestBody2 = (okhttp3.RequestBody)builder.build();
        } else {
            String string = requestBody.getBody();
            if (string == null) {
                String string4 = new JSONObject().toString();
                string = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"JSONObject().toString()");
            }
            String params = string;
            requestBody2 = okhttp3.RequestBody.Companion.create(params, MediaType.Companion.get(requestBody.getMediaType()));
        }
        return requestBody2;
    }

    public OkHttpClient(@NotNull RetryPolicy retryPolicy) {
        Intrinsics.checkParameterIsNotNull((Object)retryPolicy, (String)"retryPolicy");
        super(retryPolicy);
        this.createClient(retryPolicy);
    }

    public OkHttpClient() {
        super(null, 1, null);
        OkHttpClient.createClient$default(this, null, 1, null);
    }

    public OkHttpClient(@Nullable okhttp3.OkHttpClient client) {
        super(null, 1, null);
        this.client = client;
    }

    static {
        Companion = new Companion(null);
        JSON = MediaType.Companion.get(ContentType.JSON.toString());
        STRING = MediaType.Companion.get(ContentType.STRING.toString());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/networkingx/okhttpclient/OkHttpClient$Companion;", "", "()V", "JSON", "Lokhttp3/MediaType;", "getJSON", "()Lokhttp3/MediaType;", "STRING", "getSTRING", "okHttpClient_release"})
    public static final class Companion {
        @NotNull
        public final MediaType getJSON() {
            return JSON;
        }

        @NotNull
        public final MediaType getSTRING() {
            return STRING;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

