package com.networkingx.okhttpclient.extensions

import okhttp3.HttpUrl.Companion.toHttpUrlOrNull

fun String.buildUrl(pathParams:List<String>?=null,queryParams:HashMap<String,String>?=null
                    ,encodedPathParams:List<String>?=null,encodedQueryParams:HashMap<String,String>?=null): String {
    val urlBuilder = this.toHttpUrlOrNull()?.newBuilder()?: throw IllegalArgumentException("not a valid url")
    pathParams?.apply {
        for (value in this) {
            urlBuilder.addEncodedPathSegment(value)
        }
    }
    encodedPathParams?.apply {
        for (value in this) {
            urlBuilder.addEncodedPathSegment(value)
        }
    }
    queryParams?.apply {
        val entries: Set<Map.Entry<String, String>> = this.entries
        for ((name, value) in entries) {
            urlBuilder.addQueryParameter(name, value)
        }
    }
    encodedQueryParams?.apply {
        val entries: Set<Map.Entry<String, String>> = this.entries
        for ((name, value) in entries) {
            urlBuilder.addEncodedQueryParameter(name, value)
        }
    }
    return urlBuilder.build().toString()
}


