/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.example;

import com.netflix.servo.example.Config;
import com.netflix.servo.example.EchoHandler;
import com.netflix.servo.example.ExitHandler;
import com.netflix.servo.publish.AsyncMetricObserver;
import com.netflix.servo.publish.BasicMetricFilter;
import com.netflix.servo.publish.CounterToRateMetricTransform;
import com.netflix.servo.publish.FileMetricObserver;
import com.netflix.servo.publish.JvmMetricPoller;
import com.netflix.servo.publish.MetricObserver;
import com.netflix.servo.publish.MetricPoller;
import com.netflix.servo.publish.MonitorRegistryMetricPoller;
import com.netflix.servo.publish.PollRunnable;
import com.netflix.servo.publish.PollScheduler;
import com.netflix.servo.publish.atlas.AtlasMetricObserver;
import com.netflix.servo.publish.atlas.ServoAtlasConfig;
import com.netflix.servo.publish.graphite.GraphiteMetricObserver;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.TagList;
import com.sun.net.httpserver.HttpServer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class Main {
    private static final String CLUSTER = "nf.cluster";
    private static final String NODE = "nf.node";
    private static final String UNKNOWN = "unknown";

    private Main() {
    }

    private static MetricObserver rateTransform(MetricObserver observer) {
        long heartbeat = 2L * Config.getPollInterval();
        return new CounterToRateMetricTransform(observer, heartbeat, TimeUnit.SECONDS);
    }

    private static MetricObserver async(String name, MetricObserver observer) {
        long expireTime = 2000L * Config.getPollInterval();
        int queueSize = 10;
        return new AsyncMetricObserver(name, observer, 10, expireTime);
    }

    private static MetricObserver createFileObserver() {
        File dir = Config.getFileObserverDirectory();
        return Main.rateTransform((MetricObserver)new FileMetricObserver("servo-example", dir));
    }

    private static MetricObserver createGraphiteObserver() {
        String prefix = Config.getGraphiteObserverPrefix();
        String addr = Config.getGraphiteObserverAddress();
        return Main.rateTransform(Main.async("graphite", (MetricObserver)new GraphiteMetricObserver(prefix, addr)));
    }

    private static TagList getCommonTags() {
        HashMap<String, String> tags = new HashMap<String, String>();
        String cluster = System.getenv("NETFLIX_CLUSTER");
        tags.put(CLUSTER, cluster == null ? UNKNOWN : cluster);
        try {
            tags.put(NODE, InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            tags.put(NODE, UNKNOWN);
        }
        return BasicTagList.copyOf(tags);
    }

    private static MetricObserver createAtlasObserver() {
        ServoAtlasConfig cfg = Config.getAtlasConfig();
        TagList common = Main.getCommonTags();
        return Main.rateTransform(Main.async("atlas", (MetricObserver)new AtlasMetricObserver(cfg, common)));
    }

    private static void schedule(MetricPoller poller, List<MetricObserver> observers) {
        PollRunnable task = new PollRunnable(poller, BasicMetricFilter.MATCH_ALL, true, observers);
        PollScheduler.getInstance().addPoller(task, Config.getPollInterval(), TimeUnit.SECONDS);
    }

    private static void initMetricsPublishing() throws Exception {
        ArrayList<MetricObserver> observers = new ArrayList<MetricObserver>();
        if (Config.isFileObserverEnabled()) {
            observers.add(Main.createFileObserver());
        }
        if (Config.isAtlasObserverEnabled()) {
            observers.add(Main.createAtlasObserver());
        }
        if (Config.isGraphiteObserverEnabled()) {
            observers.add(Main.createGraphiteObserver());
        }
        PollScheduler.getInstance().start();
        Main.schedule((MetricPoller)new MonitorRegistryMetricPoller(), observers);
        if (Config.isJvmPollerEnabled()) {
            Main.schedule((MetricPoller)new JvmMetricPoller(), observers);
        }
    }

    private static void initHttpServer() throws Exception {
        final HttpServer server = HttpServer.create();
        server.createContext("/echo", new EchoHandler());
        Closeable c = new Closeable(){

            @Override
            public void close() throws IOException {
                PollScheduler.getInstance().stop();
                server.stop(5);
            }
        };
        server.createContext("/exit", new ExitHandler(c));
        server.bind(new InetSocketAddress(Config.getPort()), 0);
        server.start();
    }

    public static void main(String[] args) throws Exception {
        Main.initMetricsPublishing();
        Main.initHttpServer();
    }
}

