/*
 * Decompiled with CFR 0.152.
 */
package rx.util.async.operators;

import rx.Scheduler;
import rx.functions.Action0;
import rx.functions.Action1;

public final class Functionals {
    private static final Action1<Throwable> EMPTY_THROWABLE = new EmptyThrowable();
    private static final Action0 EMPTY = new EmptyAction();

    private Functionals() {
        throw new IllegalStateException("No instances!");
    }

    public static Action1<Throwable> emptyThrowable() {
        return EMPTY_THROWABLE;
    }

    public static Action0 empty() {
        return EMPTY;
    }

    public static Action0 fromRunnable(Runnable run, Scheduler.Worker inner) {
        if (run == null) {
            throw new NullPointerException("run");
        }
        return new ActionWrappingRunnable(run, inner);
    }

    public static Runnable toRunnable(Action0 action) {
        if (action == null) {
            throw new NullPointerException("action");
        }
        return new RunnableAction(action);
    }

    private static final class RunnableAction
    implements Runnable {
        final Action0 action;

        public RunnableAction(Action0 action) {
            this.action = action;
        }

        @Override
        public void run() {
            this.action.call();
        }
    }

    private static final class ActionWrappingRunnable
    implements Action0 {
        final Runnable run;
        final Scheduler.Worker inner;

        public ActionWrappingRunnable(Runnable run, Scheduler.Worker inner) {
            this.run = run;
            this.inner = inner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void call() {
            try {
                this.run.run();
            }
            finally {
                this.inner.unsubscribe();
            }
        }
    }

    private static final class EmptyAction
    implements Action0 {
        private EmptyAction() {
        }

        public void call() {
        }
    }

    private static final class EmptyThrowable
    implements Action1<Throwable> {
        private EmptyThrowable() {
        }

        public void call(Throwable t1) {
        }
    }
}

