/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.connection;

import com.netflix.archaius.api.Property;
import com.netflix.archaius.api.PropertyRepository;
import com.netflix.discovery.EurekaClient;
import com.netflix.evcache.connection.ConnectionFactoryBuilder;
import com.netflix.evcache.connection.DIAsciiConnectionFactory;
import com.netflix.evcache.connection.DIConnectionFactory;
import com.netflix.evcache.connection.IConnectionBuilder;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.util.EVCacheConfig;
import javax.inject.Inject;
import javax.inject.Provider;
import net.spy.memcached.ConnectionFactory;

public class DIConnectionFactoryBuilderProvider
extends ConnectionFactoryBuilder
implements Provider<IConnectionBuilder> {
    private final EurekaClient eurekaClient;
    private final PropertyRepository props;

    @Inject
    public DIConnectionFactoryBuilderProvider(EurekaClient eurekaClient, PropertyRepository props) {
        this.eurekaClient = eurekaClient;
        this.props = props;
    }

    public ConnectionFactoryBuilder get() {
        return this;
    }

    public int getMaxQueueLength(String appName) {
        return (Integer)this.props.get(appName + ".max.queue.length", Integer.class).orElse((Object)16384).get();
    }

    public int getOPQueueMaxBlockTime(String appName) {
        return (Integer)this.props.get(appName + ".operation.QueueMaxBlockTime", Integer.class).orElse((Object)10).get();
    }

    public Property<Integer> getOperationTimeout(String appName) {
        return this.props.get(appName + ".operation.timeout", Integer.class).orElse((Object)2500);
    }

    public boolean useBinaryProtocol() {
        return (Boolean)EVCacheConfig.getInstance().getPropertyRepository().get("evcache.use.binary.protocol", Boolean.class).orElse((Object)true).get();
    }

    public EurekaClient getEurekaClient() {
        return this.eurekaClient;
    }

    public PropertyRepository getProps() {
        return this.props;
    }

    public ConnectionFactory getConnectionFactory(EVCacheClient client) {
        String appName = client.getAppName();
        if (this.useBinaryProtocol()) {
            return new DIConnectionFactory(client, this.eurekaClient, this.getMaxQueueLength(appName), this.getOperationTimeout(appName), this.getOPQueueMaxBlockTime(appName));
        }
        return new DIAsciiConnectionFactory(client, this.eurekaClient, this.getMaxQueueLength(appName), this.getOperationTimeout(appName), this.getOPQueueMaxBlockTime(appName));
    }
}

