/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.archaius.api.PropertyRepository;
import com.netflix.discovery.EurekaClient;
import com.netflix.evcache.pool.EVCacheNodeList;
import com.netflix.evcache.pool.SimpleNodeListProvider;
import com.netflix.evcache.pool.eureka.EurekaNodeListProvider;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DIEVCacheNodeListProvider
implements Provider<EVCacheNodeList> {
    private static Logger log = LoggerFactory.getLogger(DIEVCacheNodeListProvider.class);
    private final EurekaClient eurekaClient;
    private PropertyRepository props;
    private final ApplicationInfoManager applicationInfoManager;

    @Inject
    public DIEVCacheNodeListProvider(ApplicationInfoManager applicationInfoManager, EurekaClient eurekaClient, PropertyRepository props) {
        this.applicationInfoManager = applicationInfoManager;
        this.eurekaClient = eurekaClient;
        this.props = props;
    }

    public EVCacheNodeList get() {
        Object provider = (Boolean)this.props.get("evcache.use.simple.node.list.provider", Boolean.class).orElse((Object)false).get() != false ? new SimpleNodeListProvider() : new EurekaNodeListProvider(this.applicationInfoManager, this.eurekaClient, this.props);
        if (log.isDebugEnabled()) {
            log.debug("EVCache Node List Provider : " + provider);
        }
        return provider;
    }
}

