/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.version;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import com.netflix.spectator.api.BasicTag;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class VersionTracker
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(VersionTracker.class);
    private AtomicLong versionGauge;
    private EVCacheClientPoolManager poolManager;

    @Inject
    public VersionTracker(EVCacheClientPoolManager poolManager) {
        this.poolManager = poolManager;
        poolManager.getEVCacheScheduledExecutor().schedule((Runnable)this, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        if (this.versionGauge == null) {
            String fullVersion = this.getClass().getPackage().getImplementationVersion() != null ? this.getClass().getPackage().getImplementationVersion() : "unknown";
            String jarName = this.getClass().getPackage().getImplementationVersion() != null ? this.getClass().getPackage().getImplementationTitle() : "unknown";
            if (log.isInfoEnabled()) {
                log.info("fullVersion : " + fullVersion + "; jarName : " + jarName);
            }
            ArrayList<BasicTag> tagList = new ArrayList<BasicTag>(3);
            tagList.add(new BasicTag("version", fullVersion));
            tagList.add(new BasicTag("jarName", jarName));
            this.versionGauge = EVCacheMetricsFactory.getInstance().getLongGauge("evcache-client", tagList);
        }
        this.versionGauge.set(1L);
        this.poolManager.getEVCacheScheduledExecutor().schedule((Runnable)this, 30L, TimeUnit.SECONDS);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

