/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.operation;

import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.servo.monitor.Stopwatch;
import com.sun.management.GarbageCollectorMXBean;
import com.sun.management.GcInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.internal.BulkGetFuture;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheBulkGetFuture<T>
extends BulkGetFuture<T> {
    private Logger log = LoggerFactory.getLogger(EVCacheBulkGetFuture.class);
    private final Map<String, Future<T>> rvMap;
    private final Collection<Operation> ops;
    private final CountDownLatch latch;
    private final String appName;
    private final ServerGroup serverGroup;
    private final Stopwatch operationDuration;

    public EVCacheBulkGetFuture(String appName, Map<String, Future<T>> m, Collection<Operation> getOps, CountDownLatch l, ExecutorService service, ServerGroup serverGroup, String metricName) {
        super(m, getOps, l, service);
        this.appName = appName;
        this.rvMap = m;
        this.ops = getOps;
        this.latch = l;
        this.serverGroup = serverGroup;
        this.operationDuration = EVCacheMetricsFactory.getStatsTimer(appName, serverGroup, metricName).start();
    }

    public Map<String, T> getSome(long to, TimeUnit unit, boolean throwException, boolean hasZF) throws InterruptedException, ExecutionException {
        HashSet<Operation> timedoutOps = new HashSet<Operation>();
        long startTime = System.currentTimeMillis();
        boolean status = this.latch.await(to, unit);
        if (!status) {
            boolean gcPause = false;
            RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
            long vmStartTime = runtimeBean.getStartTime();
            List<java.lang.management.GarbageCollectorMXBean> gcMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
            for (java.lang.management.GarbageCollectorMXBean gcMXBean : gcMXBeans) {
                long gcStartTime;
                GcInfo lastGcInfo;
                if (!(gcMXBean instanceof GarbageCollectorMXBean) || (lastGcInfo = ((GarbageCollectorMXBean)gcMXBean).getLastGcInfo()) == null || (gcStartTime = lastGcInfo.getStartTime() + vmStartTime) <= startTime) continue;
                gcPause = true;
                long gcDuration = lastGcInfo.getDuration();
                EVCacheMetricsFactory.getCounter(this.appName + "-DelayDueToGCPause").increment(gcDuration);
                if (!this.log.isDebugEnabled()) break;
                this.log.debug("Total duration due to gc event = " + gcDuration + " msec.");
                break;
            }
            if (!gcPause) {
                long gcDuration = System.currentTimeMillis() - startTime;
                EVCacheMetricsFactory.getLongGauge(this.appName + "-DelayProbablyDueToGCPause").set(Long.valueOf(gcDuration));
            }
            if (gcPause) {
                status = this.latch.await(to, unit);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Retry status : " + status);
                }
                if (status) {
                    EVCacheMetricsFactory.increment(this.appName + "-DelayDueToGCPause-Success");
                } else {
                    EVCacheMetricsFactory.increment(this.appName + "-DelayDueToGCPause-Fail");
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Total duration due to gc event = " + (System.currentTimeMillis() - startTime) + " msec.");
            }
        }
        for (Operation op : this.ops) {
            if (op.getState() != OperationState.COMPLETE) {
                if (!status) {
                    MemcachedConnection.opTimedOut((Operation)op);
                    timedoutOps.add(op);
                    continue;
                }
                MemcachedConnection.opSucceeded((Operation)op);
                continue;
            }
            MemcachedConnection.opSucceeded((Operation)op);
        }
        if (!status && !hasZF && timedoutOps.size() > 0) {
            EVCacheMetricsFactory.increment(this.appName + "-getSome-CheckedOperationTimeout");
        }
        for (Operation op : this.ops) {
            if (op.isCancelled() && throwException) {
                throw new ExecutionException(new CancellationException("Cancelled"));
            }
            if (!op.hasErrored() || !throwException) continue;
            throw new ExecutionException((Throwable)op.getException());
        }
        HashMap<String, T> m = new HashMap<String, T>();
        for (Map.Entry<String, Future<T>> me : this.rvMap.entrySet()) {
            m.put(me.getKey(), me.getValue().get());
        }
        return m;
    }

    public String getZone() {
        return this.serverGroup == null ? "NA" : this.serverGroup.getZone();
    }

    public ServerGroup getServerGroup() {
        return this.serverGroup;
    }

    public String getApp() {
        return this.appName;
    }

    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.rvMap.keySet());
    }

    public void signalComplete() {
        if (this.operationDuration != null) {
            this.operationDuration.stop();
        }
        super.signalComplete();
    }
}

