/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.metrics;

import com.netflix.config.DynamicIntProperty;
import com.netflix.evcache.EVCache;
import com.netflix.evcache.metrics.EVCacheMetrics;
import com.netflix.evcache.metrics.EVCacheOperation;
import com.netflix.evcache.metrics.Operation;
import com.netflix.evcache.metrics.Stats;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.evcache.util.EVCacheConfig;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.LongGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.StatsTimer;
import com.netflix.servo.monitor.StepCounter;
import com.netflix.servo.monitor.Timer;
import com.netflix.servo.stats.StatsConfig;
import com.netflix.servo.tag.BasicTag;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.tag.Tags;
import com.netflix.spectator.api.CompositeRegistry;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Spectator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@SuppressFBWarnings(value={"NF_LOCAL_FAST_PROPERTY", "PMB_POSSIBLE_MEMORY_BLOAT"}, justification="Creates only when needed")
public final class EVCacheMetricsFactory {
    private static final Map<String, Stats> statsMap = new ConcurrentHashMap<String, Stats>();
    private static final Map<String, Monitor<?>> monitorMap = new ConcurrentHashMap();
    private static final Map<String, DistributionSummary> distributionSummaryMap = new ConcurrentHashMap<String, DistributionSummary>();
    private static final Lock writeLock = new ReentrantReadWriteLock().writeLock();
    private static final Map<String, Timer> timerMap = new HashMap<String, Timer>();
    private static final DynamicIntProperty sampleSize = EVCacheConfig.getInstance().getDynamicIntProperty("EVCache.metrics.sample.size", 100);
    public static final Tag OWNER = Tags.newTag((String)"owner", (String)"evcache");

    public static Operation getOperation(String name) {
        return EVCacheMetricsFactory.getOperation(name, null, null, Operation.TYPE.MILLI);
    }

    public static Operation getOperation(String name, EVCache.Call op, Stats stats) {
        return EVCacheMetricsFactory.getOperation(name, op, stats, Operation.TYPE.MILLI);
    }

    public static Operation getOperation(String name, EVCache.Call op, Stats stats, Operation.TYPE type) {
        EVCacheOperation operation = new EVCacheOperation(name, op, stats, type);
        operation.start();
        return operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Stats getStats(String appName, String cacheName) {
        String key = cacheName == null ? new StringBuilder(128).append(appName).append(":NA").toString() : new StringBuilder(128).append(appName).append(":").append(cacheName).toString();
        Stats metrics = statsMap.get(key);
        if (metrics != null) {
            return metrics;
        }
        writeLock.lock();
        try {
            if (statsMap.containsKey(key)) {
                metrics = statsMap.get(key);
            } else {
                metrics = new EVCacheMetrics(appName, cacheName);
                statsMap.put(key, metrics);
            }
        }
        finally {
            writeLock.unlock();
        }
        return metrics;
    }

    public static Map<String, Stats> getAllMetrics() {
        return statsMap;
    }

    public static Map<String, Monitor<?>> getAllMonitor() {
        return monitorMap;
    }

    public static Map<String, DistributionSummary> getAllDistributionSummaryMap() {
        return distributionSummaryMap;
    }

    public static LongGauge getLongGauge(String name) {
        LongGauge gauge = (LongGauge)monitorMap.get(name);
        if (gauge == null) {
            writeLock.lock();
            try {
                if (monitorMap.containsKey(name)) {
                    gauge = (LongGauge)monitorMap.get(name);
                } else {
                    gauge = new LongGauge(MonitorConfig.builder((String)name).withTag(OWNER).build());
                    monitorMap.put(name, (Monitor<?>)gauge);
                    DefaultMonitorRegistry.getInstance().register((Monitor)gauge);
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        return gauge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LongGauge getLongGauge(String cName, TagList tag) {
        String name = new StringBuilder(128).append(cName).append(tag.toString()).toString();
        LongGauge gauge = (LongGauge)monitorMap.get(name);
        if (gauge == null) {
            writeLock.lock();
            try {
                if (monitorMap.containsKey(name)) {
                    gauge = (LongGauge)monitorMap.get(name);
                } else {
                    gauge = new LongGauge(MonitorConfig.builder((String)cName).withTags(tag).withTag(OWNER).build());
                    monitorMap.put(name, (Monitor<?>)gauge);
                    DefaultMonitorRegistry.getInstance().register((Monitor)gauge);
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        return gauge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Counter getCounter(String cName, Tag tag) {
        if (tag == null) {
            return EVCacheMetricsFactory.getCounter(cName);
        }
        String name = new StringBuilder(128).append(cName).append(tag.tagString()).toString();
        Counter counter = (Counter)monitorMap.get(name);
        if (counter == null) {
            writeLock.lock();
            try {
                if (monitorMap.containsKey(name)) {
                    counter = (Counter)monitorMap.get(name);
                } else {
                    counter = new BasicCounter(MonitorConfig.builder((String)cName).withTag(OWNER).withTag(tag).build());
                    monitorMap.put(name, (Monitor<?>)counter);
                    DefaultMonitorRegistry.getInstance().register((Monitor)counter);
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Counter getCounter(String cName, TagList tag) {
        String name = new StringBuilder(128).append(cName).append(tag.toString()).toString();
        Counter counter = (Counter)monitorMap.get(name);
        if (counter == null) {
            writeLock.lock();
            try {
                if (monitorMap.containsKey(name)) {
                    counter = (Counter)monitorMap.get(name);
                } else {
                    counter = new BasicCounter(MonitorConfig.builder((String)cName).withTag(OWNER).withTags(tag).build());
                    monitorMap.put(name, (Monitor<?>)counter);
                    DefaultMonitorRegistry.getInstance().register((Monitor)counter);
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        return counter;
    }

    public static Counter getCounter(String name) {
        return EVCacheMetricsFactory.getCounter(name, (Tag)DataSourceType.COUNTER);
    }

    public static void increment(String name) {
        Counter counter = EVCacheMetricsFactory.getCounter(name);
        counter.increment();
    }

    public static void increment(String appName, String cacheName, String metricName) {
        Counter counter = EVCacheMetricsFactory.getCounter(appName, cacheName, null, metricName, (Tag)DataSourceType.COUNTER);
        counter.increment();
    }

    public static void increment(String appName, String cacheName, String serverGroupName, String metricName) {
        Counter counter = EVCacheMetricsFactory.getCounter(appName, cacheName, serverGroupName, metricName, (Tag)DataSourceType.COUNTER);
        counter.increment();
    }

    public static Counter getCounter(String appName, String cacheName, String metricName, Tag tag) {
        return EVCacheMetricsFactory.getCounter(appName, cacheName, null, metricName, (Tag)DataSourceType.COUNTER);
    }

    public static Counter getCounter(String appName, String cacheName, String serverGroupName, String metricName, Tag tag) {
        BasicTagList tags = tag != null ? BasicTagList.of((Tag[])new Tag[]{tag}) : null;
        return EVCacheMetricsFactory.getCounter(appName, cacheName, serverGroupName, metricName, (TagList)tags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Counter getCounter(String appName, String cacheName, String serverGroupName, String metricName, TagList tags) {
        String name;
        Counter counter;
        if (tags == null) {
            tags = BasicTagList.of((String[])new String[]{"APP", appName, DataSourceType.COUNTER.getKey(), DataSourceType.COUNTER.getValue()});
        }
        if ((counter = (Counter)monitorMap.get(name = new StringBuilder(128).append(appName).append(cacheName != null ? cacheName : "").append(serverGroupName != null ? serverGroupName : "").append(metricName).append(tags.toString()).toString())) == null) {
            if (cacheName != null && cacheName.length() > 0 && !tags.containsKey("CACHE")) {
                tags = BasicTagList.concat((TagList)tags, (Tag[])new Tag[]{new BasicTag("CACHE", cacheName)});
            }
            if (serverGroupName != null && serverGroupName.length() > 0 && !tags.containsKey("ServerGroup")) {
                tags = BasicTagList.concat((TagList)tags, (Tag[])new Tag[]{new BasicTag("ServerGroup", serverGroupName)});
            }
            if (!tags.containsKey(DataSourceType.COUNTER.getKey())) {
                tags = BasicTagList.concat((TagList)tags, (Tag[])new Tag[]{DataSourceType.COUNTER});
            }
            writeLock.lock();
            try {
                if (monitorMap.containsKey(name)) {
                    counter = (Counter)monitorMap.get(name);
                } else {
                    counter = new BasicCounter(MonitorConfig.builder((String)metricName).withTag(OWNER).build().withAdditionalTags(tags));
                    monitorMap.put(name, (Monitor<?>)counter);
                    DefaultMonitorRegistry.getInstance().register((Monitor)counter);
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StepCounter getStepCounter(String appName, String cacheName, String metric) {
        String metricName = EVCacheMetricsFactory.getMetricName(appName, null, metric);
        String name = new StringBuilder(128).append(metricName).append(cacheName == null ? "" : "-" + cacheName + "-").append("type=StepCounter").toString();
        StepCounter counter = (StepCounter)monitorMap.get(name);
        if (counter != null) {
            return counter;
        }
        writeLock.lock();
        try {
            if (monitorMap.containsKey(name)) {
                StepCounter stepCounter = (StepCounter)monitorMap.get(name);
                return stepCounter;
            }
            StepCounter _counter = new StepCounter(EVCacheMetricsFactory.getMonitorConfig(metricName, appName, cacheName, metric));
            monitorMap.put(name, (Monitor<?>)_counter);
            DefaultMonitorRegistry.getInstance().register((Monitor)_counter);
            StepCounter stepCounter = _counter;
            return stepCounter;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatsTimer getStatsTimer(String appName, String cacheName, String metric) {
        String metricName = EVCacheMetricsFactory.getMetricName(appName, null, metric);
        String name = new StringBuilder(128).append(metricName).append(cacheName == null ? "" : "-" + cacheName + "-").append("type=StatsTimer").toString();
        StatsTimer duration = (StatsTimer)monitorMap.get(name);
        if (duration != null) {
            return duration;
        }
        writeLock.lock();
        try {
            if (monitorMap.containsKey(name)) {
                StatsTimer statsTimer = (StatsTimer)monitorMap.get(name);
                return statsTimer;
            }
            StatsConfig statsConfig = new StatsConfig.Builder().withPercentiles(new double[]{95.0, 99.0}).withPublishMax(true).withPublishMin(true).withPublishMean(true).withPublishCount(true).withSampleSize(sampleSize.get()).build();
            StatsTimer _duration = new StatsTimer(EVCacheMetricsFactory.getMonitorConfig(metricName, appName, cacheName, metric), statsConfig, TimeUnit.MILLISECONDS);
            monitorMap.put(name, (Monitor<?>)_duration);
            DefaultMonitorRegistry.getInstance().register((Monitor)_duration);
            StatsTimer statsTimer = _duration;
            return statsTimer;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatsTimer getStatsTimer(String appName, ServerGroup serverGroup, String metric) {
        String serverGroupName = serverGroup != null ? serverGroup.getName() : "";
        String metricName = EVCacheMetricsFactory.getMetricName(appName, null, metric);
        String name = new StringBuilder(128).append(metricName).append(serverGroupName).append("type=StatsTimer").toString();
        StatsTimer duration = (StatsTimer)monitorMap.get(name);
        if (duration != null) {
            return duration;
        }
        writeLock.lock();
        try {
            if (monitorMap.containsKey(name)) {
                StatsTimer statsTimer = (StatsTimer)monitorMap.get(name);
                return statsTimer;
            }
            StatsConfig statsConfig = new StatsConfig.Builder().withPercentiles(new double[]{95.0, 99.0}).withPublishMax(true).withPublishMin(true).withPublishMean(true).withPublishCount(true).withSampleSize(sampleSize.get()).build();
            StatsTimer _duration = new StatsTimer(EVCacheMetricsFactory.getMonitorConfig(metricName, appName, null, serverGroupName, metric), statsConfig, TimeUnit.MILLISECONDS);
            monitorMap.put(name, (Monitor<?>)_duration);
            DefaultMonitorRegistry.getInstance().register((Monitor)_duration);
            StatsTimer statsTimer = _duration;
            return statsTimer;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatsTimer getStatsTimer(String appName, ServerGroup serverGroup, String metric, String reason, String status) {
        String serverGroupName = serverGroup != null ? serverGroup.getName() : "";
        String metricName = EVCacheMetricsFactory.getMetricName(appName, null, metric);
        String name = new StringBuilder(128).append(metricName).append(serverGroupName).append(reason).append(status).append("type=StatsTimer").toString();
        StatsTimer duration = (StatsTimer)monitorMap.get(name);
        if (duration != null) {
            return duration;
        }
        writeLock.lock();
        try {
            if (monitorMap.containsKey(name)) {
                StatsTimer statsTimer = (StatsTimer)monitorMap.get(name);
                return statsTimer;
            }
            StatsConfig statsConfig = new StatsConfig.Builder().withPercentiles(new double[]{95.0, 99.0}).withPublishMax(true).withPublishMin(true).withPublishMean(true).withPublishCount(true).withSampleSize(sampleSize.get()).build();
            StatsTimer _duration = new StatsTimer(EVCacheMetricsFactory.getMonitorConfig(metricName, appName, null, serverGroupName, metric, reason, status), statsConfig, TimeUnit.MILLISECONDS);
            monitorMap.put(name, (Monitor<?>)_duration);
            DefaultMonitorRegistry.getInstance().register((Monitor)_duration);
            StatsTimer statsTimer = _duration;
            return statsTimer;
        }
        finally {
            writeLock.unlock();
        }
    }

    public static String getMetricName(String appName, String cacheName, String metric) {
        return new StringBuilder(128).append(appName).append(cacheName == null ? "-" : new StringBuilder(64).append("-").append(cacheName).append("-").toString()).append(metric).toString();
    }

    public static MonitorConfig getMonitorConfig(String appName, String cacheName, String metric) {
        return EVCacheMetricsFactory.getMonitorConfig(EVCacheMetricsFactory.getMetricName(appName, cacheName, metric), appName, cacheName, metric);
    }

    public static MonitorConfig getMonitorConfig(String name, String appName, String cacheName, String metric) {
        MonitorConfig.Builder builder = MonitorConfig.builder((String)name).withTag("APP", appName).withTag("METRIC", metric).withTag(OWNER);
        if (cacheName != null && cacheName.length() > 0) {
            builder = builder.withTag("CACHE", cacheName);
        }
        return builder.build();
    }

    public static MonitorConfig getMonitorConfig(String name, String appName, String cacheName, String serverGroup, String metric) {
        MonitorConfig.Builder builder = MonitorConfig.builder((String)name).withTag("APP", appName).withTag("METRIC", metric).withTag(OWNER);
        if (cacheName != null && cacheName.length() > 0) {
            builder = builder.withTag("CACHE", cacheName);
        }
        if (serverGroup != null && serverGroup.length() > 0) {
            builder = builder.withTag("ServerGroup", serverGroup);
        }
        return builder.build();
    }

    public static MonitorConfig getMonitorConfig(String name, String appName, String cacheName, String serverGroup, String metric, String reason, String status) {
        MonitorConfig.Builder builder = MonitorConfig.builder((String)name).withTag("APP", appName).withTag("METRIC", metric).withTag(OWNER);
        if (cacheName != null && cacheName.length() > 0) {
            builder = builder.withTag("CACHE", cacheName);
        }
        if (serverGroup != null && serverGroup.length() > 0) {
            builder = builder.withTag("ServerGroup", serverGroup);
        }
        if (reason != null && reason.length() > 0) {
            builder = builder.withTag("Reason", reason);
        }
        if (status != null && status.length() > 0) {
            builder = builder.withTag("Status", status);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timer getStatsTimer(String name) {
        Timer timer = timerMap.get(name);
        if (timer != null) {
            return timer;
        }
        writeLock.lock();
        try {
            if (timerMap.containsKey(name)) {
                Timer timer2 = timerMap.get(name);
                return timer2;
            }
            StatsConfig statsConfig = new StatsConfig.Builder().withPercentiles(new double[]{95.0, 99.0}).withPublishMax(true).withPublishMin(true).withPublishMean(true).withPublishCount(true).withSampleSize(sampleSize.get()).build();
            MonitorConfig monitorConfig = MonitorConfig.builder((String)name).withTag(OWNER).build();
            timer = new StatsTimer(monitorConfig, statsConfig, TimeUnit.MILLISECONDS);
            DefaultMonitorRegistry.getInstance().register((Monitor)timer);
            timerMap.put(name, timer);
            Timer timer3 = timer;
            return timer3;
        }
        finally {
            writeLock.unlock();
        }
    }

    public static DistributionSummary getDistributionSummary(String name, String appName, String serverGroup) {
        String metricName = EVCacheMetricsFactory.getMetricName(appName, serverGroup, name);
        DistributionSummary _ds = distributionSummaryMap.get(metricName);
        if (_ds != null) {
            return _ds;
        }
        CompositeRegistry registry = Spectator.globalRegistry();
        if (registry != null) {
            DistributionSummary ds;
            Id id = registry.createId(name);
            id = id.withTag("owner", "evcache");
            id = id.withTag("APP", appName);
            if (serverGroup != null) {
                id = id.withTag("ServerGroup", serverGroup);
            }
            if (!Monitors.isObjectRegistered((Object)(ds = registry.distributionSummary(id)))) {
                Monitors.registerObject((Object)ds);
            }
            distributionSummaryMap.put(metricName, ds);
            return ds;
        }
        return null;
    }
}

