/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.util;

import com.netflix.config.ChainedDynamicProperty;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.config.Property;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import com.netflix.spectator.api.CompositeRegistry;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Spectator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EVCacheConfig {
    private static final EVCacheConfig INSTANCE = new EVCacheConfig();
    private final Map<String, Property<?>> fastPropMap = new ConcurrentHashMap();
    private final Map<String, MonitorConfig> monitorConfigMap = new HashMap<String, MonitorConfig>();
    private EVCacheClientPoolManager _poolManager;

    private EVCacheConfig() {
    }

    public static EVCacheConfig getInstance() {
        return INSTANCE;
    }

    public void setEVCacheClientPoolManager(EVCacheClientPoolManager poolManager) {
        this._poolManager = poolManager;
    }

    public DynamicIntProperty getDynamicIntProperty(String name, int defaultValue) {
        DynamicIntProperty prop = (DynamicIntProperty)this.fastPropMap.get(name);
        if (prop != null) {
            return prop;
        }
        prop = DynamicPropertyFactory.getInstance().getIntProperty(name, defaultValue);
        this.fastPropMap.put(name, (Property<?>)prop);
        return prop;
    }

    public DynamicStringProperty getDynamicStringProperty(String name, String defaultValue) {
        DynamicStringProperty prop = (DynamicStringProperty)this.fastPropMap.get(name);
        if (prop != null) {
            return prop;
        }
        prop = DynamicPropertyFactory.getInstance().getStringProperty(name, defaultValue);
        this.fastPropMap.put(name, (Property<?>)prop);
        return prop;
    }

    public DynamicBooleanProperty getDynamicBooleanProperty(String name, Boolean defaultValue) {
        DynamicBooleanProperty prop = (DynamicBooleanProperty)this.fastPropMap.get(name);
        if (prop != null) {
            return prop;
        }
        prop = DynamicPropertyFactory.getInstance().getBooleanProperty(name, defaultValue.booleanValue());
        this.fastPropMap.put(name, (Property<?>)prop);
        return prop;
    }

    public ChainedDynamicProperty.BooleanProperty getChainedBooleanProperty(String overrideKey, String primaryKey, Boolean defaultValue) {
        String mapKey = overrideKey + primaryKey;
        ChainedDynamicProperty.BooleanProperty prop = (ChainedDynamicProperty.BooleanProperty)this.fastPropMap.get(mapKey);
        if (prop != null) {
            return prop;
        }
        prop = new ChainedDynamicProperty.BooleanProperty(overrideKey, new ChainedDynamicProperty.DynamicBooleanPropertyThatSupportsNull(primaryKey, defaultValue));
        this.fastPropMap.put(mapKey, (Property<?>)prop);
        return prop;
    }

    public ChainedDynamicProperty.IntProperty getChainedIntProperty(String overrideKey, String primaryKey, int defaultValue) {
        String mapKey = overrideKey + primaryKey;
        ChainedDynamicProperty.IntProperty prop = (ChainedDynamicProperty.IntProperty)this.fastPropMap.get(mapKey);
        if (prop != null) {
            return prop;
        }
        prop = new ChainedDynamicProperty.IntProperty(overrideKey, new DynamicIntProperty(primaryKey, defaultValue));
        this.fastPropMap.put(mapKey, (Property<?>)prop);
        return prop;
    }

    public ChainedDynamicProperty.StringProperty getChainedStringProperty(String overrideKey, String primaryKey, String defaultValue) {
        String mapKey = overrideKey + primaryKey;
        ChainedDynamicProperty.StringProperty prop = (ChainedDynamicProperty.StringProperty)this.fastPropMap.get(mapKey);
        if (prop != null) {
            return prop;
        }
        prop = new ChainedDynamicProperty.StringProperty(overrideKey, new DynamicStringProperty(primaryKey, defaultValue));
        this.fastPropMap.put(mapKey, (Property<?>)prop);
        return prop;
    }

    public MonitorConfig getMonitorConfig(String metricName, Tag tag) {
        return this.getMonitorConfig(metricName, tag, null);
    }

    public MonitorConfig getMonitorConfig(String metricName, Tag tag, TagList tagList) {
        MonitorConfig mc = this.monitorConfigMap.get(metricName);
        if (mc != null) {
            return mc;
        }
        MonitorConfig.Builder monitorConfig = MonitorConfig.builder((String)metricName);
        if (tagList != null) {
            monitorConfig.withTags(tagList);
        }
        if (tag != null) {
            monitorConfig.withTag(tag);
        }
        mc = monitorConfig.build();
        this.monitorConfigMap.put(metricName, mc);
        return mc;
    }

    public DistributionSummary getDistributionSummary(String name) {
        if (this._poolManager == null) {
            return null;
        }
        CompositeRegistry registry = Spectator.globalRegistry();
        if (registry != null) {
            DistributionSummary ds = registry.distributionSummary(name);
            if (!Monitors.isObjectRegistered((Object)ds)) {
                Monitors.registerObject((Object)ds);
            }
            return ds;
        }
        return null;
    }
}

