/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool.eureka;

import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.shared.Application;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.EVCacheClientPool;
import com.netflix.evcache.pool.eureka.EVCacheClientImpl;
import com.netflix.evcache.pool.eureka.EVCacheClientPoolImplMBean;
import com.netflix.evcache.util.ZoneFallbackIterator;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheClientPoolImpl
implements Runnable,
EVCacheClientPoolImplMBean,
EVCacheClientPool {
    private static final String GLOBAL = "GLOBAL";
    private static Logger log = LoggerFactory.getLogger(EVCacheClientPoolImpl.class);
    private String _appName;
    private ScheduledThreadPoolExecutor _scheduler;
    private String _zone;
    private DynamicBooleanProperty _zoneAffinity;
    private DynamicIntProperty _poolSize;
    private DynamicIntProperty _readTimeout;
    private final AtomicLong numberOfReadOps = new AtomicLong(0L);
    private boolean _shutdown = false;
    private final Map<String, List<EVCacheClientImpl>> memcachedInstancesByZone = new ConcurrentHashMap<String, List<EVCacheClientImpl>>();
    private final Map<String, List<EVCacheClientImpl>> memcachedReadInstancesByZone = new ConcurrentHashMap<String, List<EVCacheClientImpl>>();
    private final Map<String, List<EVCacheClientImpl>> memcachedWriteInstancesByZone = new ConcurrentHashMap<String, List<EVCacheClientImpl>>();
    private ZoneFallbackIterator memcachedFallbackReadInstances = new ZoneFallbackIterator(Collections.<String>emptySet());
    private final Map<String, DynamicBooleanProperty> writeOnlyFastPropertyMap = new ConcurrentHashMap<String, DynamicBooleanProperty>(){

        @Override
        public DynamicBooleanProperty get(Object zone) {
            DynamicBooleanProperty isZoneInWriteOnlyMode = (DynamicBooleanProperty)super.get(zone.toString());
            if (isZoneInWriteOnlyMode != null) {
                return isZoneInWriteOnlyMode;
            }
            isZoneInWriteOnlyMode = DynamicPropertyFactory.getInstance().getBooleanProperty(EVCacheClientPoolImpl.this._appName + "." + zone.toString() + ".EVCacheClientPool.writeOnly", false);
            this.put((String)zone, isZoneInWriteOnlyMode);
            return isZoneInWriteOnlyMode;
        }
    };

    @Override
    public void init(String appName) {
        this._appName = appName;
        String ec2Zone = System.getenv("EC2_AVAILABILITY_ZONE");
        this._zone = ec2Zone == null ? GLOBAL : ec2Zone;
        this._zoneAffinity = DynamicPropertyFactory.getInstance().getBooleanProperty(appName + ".EVCacheClientPool.zoneAffinity", true);
        this._poolSize = DynamicPropertyFactory.getInstance().getIntProperty(appName + ".EVCacheClientPool.poolSize", 1);
        this._readTimeout = DynamicPropertyFactory.getInstance().getIntProperty(appName + ".EVCacheClientPool.readTimeout", 100);
        if (log.isInfoEnabled()) {
            StringBuilder sbf = new StringBuilder();
            sbf.append("EVCacheClientPool:init").append("\n\tAPP - ").append(appName).append("\n\tZone - ").append(this._zone);
            sbf.append("\n\tZoneAffinity - ").append(this._zoneAffinity).append("\n\tPoolSize - ").append(this._poolSize);
            sbf.append("\n\tReadTimeout - ").append(this._readTimeout);
            log.info(sbf.toString());
        }
        this._scheduler = new ScheduledThreadPoolExecutor(1);
        this._scheduler.scheduleWithFixedDelay(this, 0L, 60L, TimeUnit.SECONDS);
        this.setupMonitoring();
    }

    @Override
    public EVCacheClient getEVCacheClient() {
        if (this.memcachedReadInstancesByZone.isEmpty()) {
            return null;
        }
        try {
            List<EVCacheClientImpl> clients;
            if (this._zoneAffinity.get()) {
                clients = this.memcachedReadInstancesByZone.get(this._zone);
                if (clients == null) {
                    String fallbackZone = this.memcachedFallbackReadInstances.next();
                    if (fallbackZone == null) {
                        return null;
                    }
                    clients = this.memcachedReadInstancesByZone.get(fallbackZone);
                }
            } else {
                clients = this.memcachedReadInstancesByZone.get(GLOBAL);
                if (clients == null) {
                    return null;
                }
            }
            return this.selectClient(clients);
        }
        catch (Throwable t) {
            log.error("Exception trying to get an readable EVCache Instances for zone " + this._zone, t);
            return null;
        }
    }

    private EVCacheClient selectClient(List<EVCacheClientImpl> clients) {
        if (clients == null) {
            return null;
        }
        if (clients.size() == 1) {
            return clients.get(0);
        }
        long currentVal = this.numberOfReadOps.incrementAndGet();
        int index = (int)currentVal % clients.size();
        return clients.get(index);
    }

    @Override
    public EVCacheClient getEVCacheClientExcludeZone(String zone) {
        if (this.memcachedReadInstancesByZone.isEmpty()) {
            return null;
        }
        if (zone == null || zone.length() == 0) {
            return this.getEVCacheClient();
        }
        try {
            if (this._zoneAffinity.get()) {
                String fallbackZone = this.memcachedFallbackReadInstances.next(zone);
                if (fallbackZone == null || fallbackZone.equals(zone)) {
                    return null;
                }
                List<EVCacheClientImpl> clients = this.memcachedReadInstancesByZone.get(fallbackZone);
                return this.selectClient(clients);
            }
            return null;
        }
        catch (Throwable t) {
            log.error("Exception trying to get an readable EVCache Instances for zone " + this._zone, t);
            return null;
        }
    }

    @Override
    public EVCacheClient[] getAllEVCacheClients() {
        try {
            if (this._zoneAffinity.get()) {
                EVCacheClient[] clientArr = new EVCacheClient[this.memcachedWriteInstancesByZone.size()];
                int i = 0;
                for (String zone : this.memcachedWriteInstancesByZone.keySet()) {
                    List<EVCacheClientImpl> clients = this.memcachedWriteInstancesByZone.get(zone);
                    long currentVal = this.numberOfReadOps.incrementAndGet();
                    int index = (int)currentVal % clients.size();
                    clientArr[i++] = clients.get(index);
                }
                return clientArr;
            }
            EVCacheClient[] clientArr = new EVCacheClient[1];
            List<EVCacheClientImpl> clients = this.memcachedWriteInstancesByZone.get(GLOBAL);
            if (clients == null) {
                return new EVCacheClient[0];
            }
            clientArr[0] = clients.get(0);
            return clientArr;
        }
        catch (Throwable t) {
            log.error("Exception trying to get an array of writable EVCache Instances", t);
            return null;
        }
    }

    private void refresh() throws IOException {
        this.refresh(false);
    }

    private boolean haveInstancesInZoneChanged(String zone, List<String> discoveredHostsInZone) {
        List<EVCacheClientImpl> clients = this.memcachedInstancesByZone.get(zone);
        if (clients == null) {
            return true;
        }
        for (EVCacheClientImpl client : clients) {
            int activeServerCount = client.getConnectionObserver().getActiveServerCount();
            int inActiveServerCount = client.getConnectionObserver().getInActiveServerCount();
            int sizeInDiscovery = discoveredHostsInZone.size();
            if (log.isDebugEnabled()) {
                log.debug("\n\tApp : " + this._appName + "\n\tActive Count : " + activeServerCount + "\n\tInactive Count : " + inActiveServerCount + "\n\tDiscovery Count : " + sizeInDiscovery);
            }
            if (activeServerCount == sizeInDiscovery && inActiveServerCount <= 0) continue;
            if (log.isInfoEnabled()) {
                log.info("\n\t" + this._appName + " & " + zone + " experienced an issue.\n\tActive Server Count : " + activeServerCount);
            }
            if (log.isInfoEnabled()) {
                log.info("\n\tInActive Server Count : " + inActiveServerCount + "\n\tDiscovered Instances : " + sizeInDiscovery);
            }
            for (String instance : discoveredHostsInZone) {
                String hostname = instance.substring(0, instance.indexOf(58));
                if (client.getConnectionObserver().getActiveServerInfo().containsKey(hostname) || client.getConnectionObserver().getInActiveServerInfo().containsKey(hostname)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("AppName :" + this._appName + "; Zone : " + zone + "; instance : " + instance + " not found and will shutdown the client and init it again.");
                }
                return true;
            }
        }
        return false;
    }

    private void verifyZonesChanges(Map<String, List<String>> instances) {
        for (String zone : this.memcachedInstancesByZone.keySet()) {
            if (instances.containsKey(zone)) continue;
            this.shutdownInstancesInZone(zone);
        }
    }

    private void shutdownInstancesInZone(String zone) {
        this.memcachedReadInstancesByZone.remove(zone);
        this.memcachedWriteInstancesByZone.remove(zone);
        List<EVCacheClientImpl> currentInstancesInZone = this.memcachedInstancesByZone.remove(zone);
        this.shutdownClientsInZone(currentInstancesInZone);
    }

    private List<InetSocketAddress> getMemcachedSocketAddressList(List<String> discoveredHostsInZone) {
        ArrayList<InetSocketAddress> memcachedNodesInZone = new ArrayList<InetSocketAddress>();
        for (String hostAddress : discoveredHostsInZone) {
            int colonIndex = hostAddress.lastIndexOf(58);
            String hostName = hostAddress.substring(0, colonIndex);
            String portNum = hostAddress.substring(colonIndex + 1);
            memcachedNodesInZone.add(new InetSocketAddress(hostName, Integer.parseInt(portNum)));
        }
        return memcachedNodesInZone;
    }

    private void shutdownClientsInZone(List<EVCacheClientImpl> clients) {
        if (clients == null || clients.isEmpty()) {
            return;
        }
        for (EVCacheClientImpl oldClient : clients) {
            try {
                boolean obsRemoved = oldClient.removeConnectionObserver();
                if (log.isDebugEnabled()) {
                    log.debug("Connection observer removed " + obsRemoved);
                }
                boolean status = oldClient.shutdown(60L, TimeUnit.SECONDS);
                if (!log.isDebugEnabled()) continue;
                log.debug("Shutting down -> Client {" + ((Object)oldClient).toString() + "}; status : " + status);
            }
            catch (Exception ex) {
                log.error("Exception while shutting down the old Client", (Throwable)ex);
            }
        }
    }

    private void setupNewClientsByZone(String zone, List<EVCacheClientImpl> newClients) {
        List<EVCacheClientImpl> currentClients = this.memcachedInstancesByZone.put(zone, newClients);
        DynamicBooleanProperty isZoneInWriteOnlyMode = this.writeOnlyFastPropertyMap.get(zone);
        if (isZoneInWriteOnlyMode.get()) {
            this.memcachedReadInstancesByZone.remove(zone);
        } else {
            this.memcachedReadInstancesByZone.put(zone, newClients);
        }
        this.memcachedWriteInstancesByZone.put(zone, newClients);
        if (currentClients == null || currentClients.isEmpty()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Replaced an existing Pool for zone : " + zone + "; and app " + this._appName + " ;\n\tOldClients : " + currentClients + ";\n\tNewClients : " + newClients);
        }
        for (EVCacheClientImpl client : currentClients) {
            if (client.isShutdown()) continue;
            if (log.isDebugEnabled()) {
                log.debug("Shutting down in Fallback -> AppName : " + this._appName + "; Zone : " + zone + "; client {" + client + "};");
            }
            try {
                if (client.getConnectionObserver() != null) {
                    boolean obsRemoved = client.removeConnectionObserver();
                    if (log.isDebugEnabled()) {
                        log.debug("Connection observer removed " + obsRemoved);
                    }
                }
                boolean status = client.shutdown(60L, TimeUnit.SECONDS);
                if (!log.isDebugEnabled()) continue;
                log.debug("Shutting down {" + client + "} ; status : " + status);
            }
            catch (Exception ex) {
                log.error("Exception while shutting down the old Client", (Throwable)ex);
            }
        }
        this.shutdownClientsInZone(currentClients);
    }

    private void updateMemcachedReadInstancesByZone() {
        for (String zone : this.memcachedInstancesByZone.keySet()) {
            DynamicBooleanProperty isZoneInWriteOnlyMode = this.writeOnlyFastPropertyMap.get(zone);
            if (isZoneInWriteOnlyMode.get()) {
                if (!this.memcachedReadInstancesByZone.containsKey(zone)) continue;
                this.memcachedReadInstancesByZone.remove(zone);
                continue;
            }
            if (this.memcachedReadInstancesByZone.containsKey(zone)) continue;
            this.memcachedReadInstancesByZone.put(zone, this.memcachedInstancesByZone.get(zone));
        }
        if (this.memcachedReadInstancesByZone.size() != this.memcachedFallbackReadInstances.getSize()) {
            this.memcachedFallbackReadInstances = new ZoneFallbackIterator(this.memcachedReadInstancesByZone.keySet());
        }
    }

    private synchronized void refresh(boolean force) throws IOException {
        try {
            Map<String, List<String>> instances = this.discoverInstances();
            if (instances == null || instances.isEmpty()) {
                return;
            }
            this.verifyZonesChanges(instances);
            for (Map.Entry<String, List<String>> zoneEntry : instances.entrySet()) {
                boolean instanceChangeInZone;
                List<String> discoveredHostsInZone;
                String zone = zoneEntry.getKey();
                List<String> discoverdInstanceInZone = zoneEntry.getValue();
                List<Object> list = discoveredHostsInZone = discoverdInstanceInZone == null ? Collections.emptyList() : discoverdInstanceInZone;
                if (log.isDebugEnabled()) {
                    log.debug("\n\tApp : " + this._appName + "\n\tZone : " + zone + "\n\tSize : " + discoveredHostsInZone.size() + "\n\tInstances in zone : " + discoveredHostsInZone);
                }
                if (instanceChangeInZone = force) {
                    if (log.isWarnEnabled()) {
                        log.warn("FORCE REFRESH :: AppName :" + this._appName + "; Zone : " + zone + "; Changed : " + instanceChangeInZone);
                    }
                } else {
                    instanceChangeInZone = this.haveInstancesInZoneChanged(zone, discoveredHostsInZone);
                    if (!instanceChangeInZone) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("AppName :" + this._appName + "; Zone : " + zone + "; Changed : " + instanceChangeInZone);
                        continue;
                    }
                }
                List<InetSocketAddress> memcachedSAInZone = this.getMemcachedSocketAddressList(discoveredHostsInZone);
                int poolSize = this._poolSize.get();
                ArrayList<EVCacheClientImpl> newClients = new ArrayList<EVCacheClientImpl>(poolSize);
                for (int i = 0; i < poolSize; ++i) {
                    int maxQueueSize = ConfigurationManager.getConfigInstance().getInt(this._appName + ".max.queue.length", 16384);
                    EVCacheClientImpl client = new EVCacheClientImpl(this._appName, zone, i, maxQueueSize, this._readTimeout, memcachedSAInZone);
                    newClients.add(client);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("AppName :" + this._appName + "; Zone : " + zone + "; intit : client.getId() : " + client.getId());
                }
                this.setupNewClientsByZone(zone, newClients);
            }
            this.updateMemcachedReadInstancesByZone();
        }
        catch (Throwable t) {
            log.error("Exception while refreshing the Server list", t);
        }
    }

    private Map<String, List<String>> discoverInstances() throws IOException {
        if (this._shutdown || ApplicationInfoManager.getInstance().getInfo().getStatus() == InstanceInfo.InstanceStatus.DOWN) {
            return Collections.emptyMap();
        }
        Application app = DiscoveryManager.getInstance().getDiscoveryClient().getApplication(this._appName);
        if (app == null) {
            return Collections.emptyMap();
        }
        List appInstances = app.getInstances();
        HashMap<String, List<String>> instancesSpecific = new HashMap<String, List<String>>();
        for (InstanceInfo iInfo : appInstances) {
            DataCenterInfo dcInfo = iInfo.getDataCenterInfo();
            Map metaInfo = iInfo.getMetadata();
            if (DataCenterInfo.Name.Amazon != dcInfo.getName()) {
                if (!log.isErrorEnabled()) continue;
                log.error("This is not a AmazonDataCenter. Cannot proceed. DataCenterInfo : " + dcInfo);
                continue;
            }
            if (InstanceInfo.InstanceStatus.UP != iInfo.getStatus()) {
                if (!log.isWarnEnabled()) continue;
                log.warn("The Status of the instance in Discovery is not UP. InstanceInfo : " + iInfo);
                continue;
            }
            AmazonInfo amznInfo = (AmazonInfo)dcInfo;
            String zone = this._zoneAffinity.get() ? amznInfo.get(AmazonInfo.MetaDataKey.availabilityZone) : GLOBAL;
            String evcachePort = metaInfo.containsKey("evcache.port") ? (String)metaInfo.get("evcache.port") : "11211";
            String hostName = amznInfo.get(AmazonInfo.MetaDataKey.publicHostname);
            if (hostName == null) {
                if (!log.isErrorEnabled()) continue;
                log.error("The public hostnanme is null, will not be able to add this host to the evcache cluster. AmazonInfo : " + amznInfo);
                continue;
            }
            if (!instancesSpecific.containsKey(zone)) {
                instancesSpecific.put(zone, new ArrayList());
            }
            List instancesInZone = (List)instancesSpecific.get(zone);
            instancesInZone.add(hostName + ":" + evcachePort);
        }
        return instancesSpecific;
    }

    @Override
    public void run() {
        block2: {
            try {
                this.refresh();
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Error Refreshing EVCache Instance list for " + this._appName, t);
            }
        }
    }

    @Override
    public void shutdown() {
        if (log.isInfoEnabled()) {
            log.info("EVCacheClientPool for App : " + this._appName + " and Zone : " + this._zone + " is being shutdown.");
        }
        this._shutdown = true;
        this._scheduler.shutdown();
        for (List<EVCacheClientImpl> instancesInAZone : this.memcachedInstancesByZone.values()) {
            for (EVCacheClientImpl client : instancesInAZone) {
                client.shutdown(30L, TimeUnit.SECONDS);
                client.getConnectionObserver().shutdown();
            }
        }
        this.setupMonitoring();
    }

    private void setupMonitoring() {
        block5: {
            try {
                ObjectName mBeanName = ObjectName.getInstance("com.netflix.evcache:Group=" + this._appName + ",SubGroup=pool");
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mbeanServer.isRegistered(mBeanName)) {
                    if (log.isInfoEnabled()) {
                        log.info("MBEAN with name " + mBeanName + " has been registered. Will unregister the previous instance and register a new one.");
                    }
                    mbeanServer.unregisterMBean(mBeanName);
                }
                if (!this._shutdown) {
                    mbeanServer.registerMBean(this, mBeanName);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("Exception", (Throwable)e);
            }
        }
    }

    @Override
    @Monitor(name="Instances", type=DataSourceType.COUNTER)
    public int getInstanceCount() {
        int instances = 0;
        for (String zone : this.memcachedInstancesByZone.keySet()) {
            instances += this.memcachedInstancesByZone.get(zone).get(0).getConnectionObserver().getActiveServerCount();
        }
        return instances;
    }

    @Override
    public Map<String, String> getInstancesByZone() {
        HashMap<String, String> instanceMap = new HashMap<String, String>();
        for (String zone : this.memcachedInstancesByZone.keySet()) {
            List<EVCacheClientImpl> instanceList = this.memcachedInstancesByZone.get(zone);
            instanceMap.put(zone, instanceList.toString());
        }
        return instanceMap;
    }

    @Override
    @Monitor(name="InstanceCountByZone", type=DataSourceType.INFORMATIONAL)
    public Map<String, Integer> getInstanceCountByZone() {
        HashMap<String, Integer> instancesByZone = new HashMap<String, Integer>(this.memcachedInstancesByZone.size() * 2);
        for (String zone : this.memcachedInstancesByZone.keySet()) {
            instancesByZone.put(zone, this.memcachedInstancesByZone.get(zone).get(0).getConnectionObserver().getActiveServerCount());
        }
        return instancesByZone;
    }

    @Override
    public Map<String, String> getReadZones() {
        HashMap<String, String> instanceMap = new HashMap<String, String>();
        for (String key : this.memcachedReadInstancesByZone.keySet()) {
            instanceMap.put(key, this.memcachedReadInstancesByZone.get(key).toString());
        }
        return instanceMap;
    }

    @Override
    @Monitor(name="ReadInstanceCountByZone", type=DataSourceType.INFORMATIONAL)
    public Map<String, Integer> getReadInstanceCountByZone() {
        HashMap<String, Integer> instanceMap = new HashMap<String, Integer>();
        for (String key : this.memcachedReadInstancesByZone.keySet()) {
            instanceMap.put(key, this.memcachedReadInstancesByZone.get(key).get(0).getConnectionObserver().getActiveServerCount());
        }
        return instanceMap;
    }

    @Override
    public Map<String, String> getWriteZones() {
        HashMap<String, String> instanceMap = new HashMap<String, String>();
        for (String key : this.memcachedWriteInstancesByZone.keySet()) {
            instanceMap.put(key, this.memcachedWriteInstancesByZone.get(key).toString());
        }
        return instanceMap;
    }

    public Map<String, List<EVCacheClientImpl>> getAllInstancesByZone() {
        return Collections.unmodifiableMap(this.memcachedInstancesByZone);
    }

    @Override
    @Monitor(name="WriteInstanceCountByZone", type=DataSourceType.INFORMATIONAL)
    public Map<String, Integer> getWriteInstanceCountByZone() {
        HashMap<String, Integer> instanceMap = new HashMap<String, Integer>();
        for (String key : this.memcachedWriteInstancesByZone.keySet()) {
            instanceMap.put(key, this.memcachedWriteInstancesByZone.get(key).get(0).getConnectionObserver().getActiveServerCount());
        }
        return instanceMap;
    }

    @Override
    public void refreshPool() {
        block2: {
            try {
                this.refresh(true);
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Error Refreshing EVCache Instance list from MBean : " + this._appName, t);
            }
        }
    }

    @Override
    public boolean supportsFallback() {
        return this.memcachedFallbackReadInstances.getSize() > 1;
    }

    @Override
    public int getClusterSize() {
        return this.memcachedInstancesByZone.size();
    }
}

