/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.sample;

import com.netflix.evcache.EVCache;
import com.netflix.evcache.EVCacheException;
import java.util.concurrent.Future;

public class EVCacheClientSample {
    private final EVCache evCache;
    private static boolean verboseMode = false;

    public EVCacheClientSample() {
        String deploymentDescriptor = System.getenv("EVC_SAMPLE_DEPLOYMENT");
        if (deploymentDescriptor == null) {
            deploymentDescriptor = "SERVERGROUP1=localhost:11211;SERVERGROUP2=localhost:11212";
        }
        System.setProperty("EVCACHE_APP1.use.simple.node.list.provider", "true");
        System.setProperty("EVCACHE_APP1-NODES", deploymentDescriptor);
        this.evCache = new EVCache.Builder().setAppName("EVCACHE_APP1").build();
    }

    public void setKey(String key, String value, int timeToLive) throws Exception {
        try {
            Future[] _future;
            for (Future f : _future = this.evCache.set(key, (Object)value, timeToLive)) {
                boolean didSucceed = (Boolean)f.get();
                if (!verboseMode) continue;
                System.out.println("per-shard set success code for key " + key + " is " + didSucceed);
            }
            if (!verboseMode) {
                System.out.println("finished setting key " + key);
            }
        }
        catch (EVCacheException e) {
            e.printStackTrace();
        }
    }

    public String getKey(String key) {
        try {
            String _response = (String)this.evCache.get(key);
            return _response;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        verboseMode = "true".equals(System.getenv("EVCACHE_SAMPLE_VERBOSE"));
        if (verboseMode) {
            System.out.println("To run this sample app without using Gradle:");
            System.out.println("java -cp " + System.getProperty("java.class.path") + " com.netflix.evcache.sample.EVCacheClientSample");
        }
        try {
            String value;
            String key;
            int i;
            EVCacheClientSample evCacheClientSample = new EVCacheClientSample();
            for (i = 0; i < 10; ++i) {
                key = "key_" + i;
                value = "data_" + i;
                int ttl = 86400;
                evCacheClientSample.setKey(key, value, ttl);
            }
            for (i = 0; i < 10; ++i) {
                key = "key_" + i;
                value = evCacheClientSample.getKey(key);
                System.out.println("Get of " + key + " returned " + value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

