package com.netcore.android.notification.services

import android.content.Context
import android.content.Intent
import androidx.core.app.JobIntentService
import com.netcore.android.logger.SMTLogger
import com.netcore.android.notification.SMTNotificationConstants
import com.netcore.android.notification.SMTNotificationGeneratorProvider
import com.netcore.android.notification.SMTPNHandler
import com.netcore.android.notification.SMTScheduleNotification
import java.lang.ref.WeakReference

class SMTScheduledNotificationService : JobIntentService() {
    val TAG = SMTAlarmService::class.java.simpleName
    override fun onHandleWork(intent: Intent) {

        try {
            val mScheduledPNData = intent.getStringExtra(SMTScheduleNotification.NOTIFICATION_DATA)
            val mSourceType = intent.getIntExtra(SMTScheduleNotification.SOURCE_TYPE, 0)
            val mSmtNotification = SMTScheduleNotification()
            if (mScheduledPNData != null) {
                val mNotificationData = mSmtNotification.getNotificationModel(mScheduledPNData, mSourceType)
                if (mNotificationData != null) {
                    SMTPNHandler(SMTNotificationGeneratorProvider()).handleNotification(applicationContext, mScheduledPNData, mSourceType, false)
                    mSmtNotification.updateScheduledNotification(applicationContext, mNotificationData.mTrid, SMTNotificationConstants.NOTIF_IS_RENDERED)
                }
            }
        } catch (e: Exception) {
            SMTLogger.e(TAG, e.message.toString())
        }
    }

    companion object {
        val jobId = 1002
        fun enqueWork(context: Context, intent: Intent) {
            enqueueWork(context, SMTScheduledNotificationService::class.java, jobId, intent)
        }
    }
}