package com.netcore.android.notification.models

import android.os.Parcel
import android.os.Parcelable

@Suppress("UNCHECKED_CAST")
/**
 * Copyright © 2019 Netcore. All rights reserved.
 *
 * Class holds Notification Action Button Data
 *
 * @author Netcore
 * @version 1.0
 * @since 26-02-2019
 */
class SMTNotificationData(builder: NotificationBuilder) : Parcelable {
    var mSource: Int = 1 // APN or Push Amp
        private set
    var isFromSmartech: Boolean = false
        private set
    var mNotificationType: String?
        private set
    var mTrid: String
        private set
    var mTitle: String?
        private set
    var mMessage: String?
        private set
    var mSubtitle: String?
        private set
    var mMediaUrl: String?
        private set
    var mDeepLinkPath: String?
        private set
    var mPNMeta: String
        private set
    var mActionButtonList: ArrayList<SMTActionButtonData>?
        private set
    var mCarouselList: ArrayList<SMTCarouselItemData>?
        private set
    var mCustomPayload: HashMap<String, Any>?
        private set

    var mSmtAttributePayload: HashMap<String, String>?
        private set

    var mSound: Boolean = true
        private set
    var mSoundFile: String?
        private set
    var mChannelId: String?
        private set

    var mTitleHtml: String? = null
        private set
    var mMessageHtml: String? = null
        private set
    var mSubtitleHtml: String? = null
        private set
    var mStickyEnabled: Boolean = false
        private set

    var mStatus: String? = null // (sent/delivered/viewed/clicked/dismissed)
    var mPublishedTimeStamp: String? = null
    var mScheduledDate: String? = null
    var mTtl: String? = null
    var mScheduledPNTimeStamp: String? = null
    var mScheduledPNStatus: String? = null
    var action: String? = null
    var isPlaying: Boolean? = false // Used for audio notificaiton to keep track
    var notificationId: Int = 0 // ID of notificaiton

    //Internal notification controlling variables
    var mMediaLocalPath: String? = null
    var mDownloadStatus: Int = 0

    var mIsDownloadInProgress = false
    var mPayload: String? = null
    var mIsForInbox: Boolean = false
    var mRemoveSchedulePn: ArrayList<String>? = null
    var mSourceType: Int = 0
    var mIsScheduledPN: Int = 0
    var mCollapse: String? = null

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeInt(mSource)
        parcel.writeValue(isFromSmartech)
        parcel.writeString(mNotificationType)
        parcel.writeString(mTrid)
        parcel.writeString(mTitle)
        parcel.writeString(mMessage)
        parcel.writeString(mSubtitle)
        parcel.writeString(mMediaUrl)
        parcel.writeString(mDeepLinkPath)
        parcel.writeString(mPNMeta)
        parcel.writeTypedList(mActionButtonList)
        parcel.writeTypedList(mCarouselList)
        parcel.writeSerializable(mCustomPayload)
        parcel.writeSerializable(mSmtAttributePayload)
        parcel.writeString(mStatus)
        parcel.writeString(mPublishedTimeStamp)
        parcel.writeString(mScheduledDate)
        parcel.writeString(mMediaLocalPath)
        parcel.writeValue(mSound)
        parcel.writeString(mSoundFile)
        parcel.writeString(mChannelId)
        parcel.writeString(mTitleHtml)
        parcel.writeString(mMessageHtml)
        parcel.writeString(mSubtitleHtml)
        parcel.writeValue(mStickyEnabled)
        parcel.writeString(action)
        parcel.writeValue(isPlaying)
        parcel.writeValue(notificationId)
        parcel.writeValue(mDownloadStatus)
        parcel.writeValue(mIsDownloadInProgress)
        parcel.writeString(mPayload)
        parcel.writeString(mTtl)
        parcel.writeInt(mSourceType)
        parcel.writeInt(mIsScheduledPN)
        parcel.writeString(mCollapse)

    }

    constructor(parcel: Parcel) : this(NotificationBuilder()
            .setSource(parcel.readInt())
            .setIsFromSmartech(parcel.readValue(Boolean::class.java.classLoader) as Boolean)
            .setNotificationType(parcel.readString() ?: "")
            .setTrId(parcel.readString() ?: "")
            .setTitle(parcel.readString() ?: "")
            .setMessage(parcel.readString() ?: "")
            .setSubtitle(parcel.readString() ?: "")
            .setMediaUrl(parcel.readString() ?: "")
            .setDeepLinkPath(parcel.readString() ?: "")
            .setPNMeta(parcel.readString() ?: "")
            .setActionButtonList(arrayListOf<SMTActionButtonData>().apply { parcel.readTypedList(this, SMTActionButtonData.CREATOR) })
            .setCarouselList(arrayListOf<SMTCarouselItemData>().apply { parcel.readTypedList(this, SMTCarouselItemData.CREATOR) })
            .setCustomPayload(parcel.readSerializable() as? HashMap<String, Any>)
            .setSmtAttributePayload(parcel.readSerializable() as? HashMap<String, String>)
            .setStatus(parcel.readString() ?: "")
            .setPublishedDate(parcel.readString() ?: "")
            .setScheduledDate(parcel.readString() ?: "")

            .setMediaLocalPath(parcel.readString() ?: "")
            .setSound(parcel.readValue(Boolean::class.java.classLoader) as Boolean)
            .setSoundFile(parcel.readString() ?: "")
            .setChannelId(parcel.readString() ?: "")
            .setTitleHtml(parcel.readString() ?: "")
            .setMessageHtml(parcel.readString() ?: "")
            .setSubtitleHtml(parcel.readString() ?: "")
            .setStickyEnabled(parcel.readValue(Boolean::class.java.classLoader) as Boolean)
//            .setModifiedDate(parcel.readString() ?: "")
//            .setModifiedDate(parcel.readString() ?: "")
    ) {


        action = parcel.readString()
        isPlaying = parcel.readValue(Boolean::class.java.classLoader) as? Boolean
        notificationId = parcel.readValue(Int::class.java.classLoader) as? Int ?: 0
        mDownloadStatus = parcel.readValue(Int::class.java.classLoader) as? Int ?: 0
        mIsDownloadInProgress = parcel.readValue(Boolean::class.java.classLoader) as Boolean
        mPayload = parcel.readString()
        mTtl = parcel.readString()
        mSourceType = parcel.readInt()
        mIsScheduledPN = parcel.readInt()
        mCollapse = parcel.readString()
    }

    init {
        mSource = builder.mSource
        isFromSmartech = builder.isFromSmartech
        mNotificationType = builder.mNotificationType
        mTrid = builder.mTrid

        //todo add flag
        mTitle = if (!builder.mTitleHtml.isNullOrEmpty()) {
            builder.mTitleHtml
        } else {
            builder.mTitle
        }

        mMessage = if (!builder.mMessageHtml.isNullOrEmpty()) {
            builder.mMessageHtml
        } else {
            builder.mMessage
        }

        mSubtitle = if (!builder.mSubtitleHtml.isNullOrEmpty()) {
            builder.mSubtitleHtml
        } else {
            builder.mSubtitle
        }

        mMediaUrl = builder.mMediaUrl
        mDeepLinkPath = builder.mDeepLinkPath
        mPNMeta = builder.mPNMeta
        mActionButtonList = builder.mSMTActionButtonList
        mCarouselList = builder.mSMTCarouselList
        mCustomPayload = builder.customPayload
        mSmtAttributePayload = builder.smtAttributePayload
        mStatus = builder.mNotifStatus
        mPublishedTimeStamp = builder.mPublishedTimeStamp
//        mModifiedTimeStamp = builder.mModifiedPNTimeStamp
//        mScheduledPNTimeStamp = builder.mScheduledPNTimeStamp
        mScheduledDate = builder.mScheduledDate
        mMediaLocalPath = builder.mMediaLocalPath
        mSound = builder.mSound
        mSoundFile = builder.mSoundFile
        mChannelId = builder.mChannelId
        mTitleHtml = builder.mTitleHtml
        mMessageHtml = builder.mMessageHtml
        mSubtitleHtml = builder.mSubtitleHtml
        mStickyEnabled = builder.mStickyEnabled
        mTtl = builder.mTtl
        mSourceType = builder.mSourceType
        mIsScheduledPN = builder.mIsScheduledPN
        mCollapse = builder.mCollapse

    }

    class NotificationBuilder {
        var mSource: Int = 1
            private set
        var isFromSmartech: Boolean = false
            private set
        lateinit var mNotificationType: String
            private set
        lateinit var mTrid: String
            private set
        var mTitle: String? = null
            private set
        var mMessage: String? = null
            private set
        var mSubtitle: String? = null
            private set
        var mMediaUrl: String? = null
            private set
        var mDeepLinkPath: String? = null
            private set
        lateinit var mPNMeta: String
            private set
        var mSMTActionButtonList: ArrayList<SMTActionButtonData>? = null
            private set
        var mSMTCarouselList: ArrayList<SMTCarouselItemData>? = null
            private set
        var customPayload: HashMap<String, Any>? = null
            private set
        var smtAttributePayload: HashMap<String, String>? = null
            private set
        var mNotifStatus: String? = null
            private set
        var mPublishedTimeStamp: String? = null
            private set
        var mScheduledDate: String? = null
            private set
        var mTtl: String? = null
            private set
        var mMediaLocalPath: String? = null
            private set

        var mSound: Boolean = true
            private set
        var mSoundFile: String? = null
            private set
        var mChannelId: String? = null
            private set
        var mSourceType: Int = 0
            private set
        var mIsScheduledPN: Int = 0
            private set

        var mCollapse: String? = null
        var mTitleHtml: String? = null
            private set
        var mMessageHtml: String? = null
            private set
        var mSubtitleHtml: String? = null
            private set
        var mStickyEnabled: Boolean = false
            private set

        var mIsHtml: Boolean = false
            private set

        fun setStatus(status: String) = apply { this.mNotifStatus = status }

        fun setPublishedDate(timestamp: String) = apply { this.mPublishedTimeStamp = timestamp }

        fun setScheduledDate(timestamp: String) = apply { this.mScheduledDate = timestamp }

        fun setTtl(ttl: String) = apply { this.mTtl = ttl }

        fun setSource(source: Int) = apply { this.mSource = source }

        fun setCustomPayload(payload: HashMap<String, Any>?) = apply { this.customPayload = payload }

        fun setSmtAttributePayload(attribute: HashMap<String, String>?) = apply { this.smtAttributePayload = attribute }

        fun setDeepLinkPath(path: String) = apply { this.mDeepLinkPath = path }

        fun setTitle(title: String) = apply { this.mTitle = title }

        fun setMessage(message: String) = apply { this.mMessage = message }

        fun setSubtitle(subtitle: String) = apply { this.mSubtitle = subtitle }

        fun setTrId(trId: String) = apply { this.mTrid = trId }

        fun setNotificationType(type: String) = apply {
            this.mNotificationType = type
        }

        fun setPNMeta(pnMeta: String) = apply {
            this.mPNMeta = pnMeta
        }

        fun setCarouselList(carousel: ArrayList<SMTCarouselItemData>) = apply { this.mSMTCarouselList = carousel }

        fun setActionButtonList(actionButtonList: ArrayList<SMTActionButtonData>) = apply { this.mSMTActionButtonList = actionButtonList }

        fun setMediaUrl(url: String) = apply { this.mMediaUrl = url }

        fun setMediaLocalPath(path: String) = apply { this.mMediaLocalPath = path }

        fun build(): SMTNotificationData {
            return SMTNotificationData(this)
        }

        fun setIsFromSmartech(isSmartech: Boolean) = apply { this.isFromSmartech = isSmartech }

        fun setSound(sound: Boolean) = apply { this.mSound = sound }

        fun setSoundFile(soundFile: String) = apply { this.mSoundFile = soundFile }

        fun setChannelId(channelId: String) = apply { this.mChannelId = channelId }

        fun setSourceType(sourceType: Int) = apply { this.mSourceType = sourceType }

        fun setIsScheduledPn(isScheduledPN: Int) = apply { this.mIsScheduledPN = isScheduledPN }

        fun setCollapse(collapse: String) = apply { this.mCollapse = collapse }

        fun setTitleHtml(titleHtml: String) = apply { this.mTitleHtml = titleHtml }

        fun setMessageHtml(messageHtml: String) = apply { this.mMessageHtml = messageHtml }

        fun setSubtitleHtml(subtitleHtml: String) = apply { this.mSubtitleHtml = subtitleHtml }

        fun setStickyEnabled(enabled: Boolean) = apply { this.mStickyEnabled = enabled }
    }


    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<SMTNotificationData> {
        override fun createFromParcel(parcel: Parcel): SMTNotificationData {
            return SMTNotificationData(parcel)
        }

        override fun newArray(size: Int): Array<SMTNotificationData?> {
            return arrayOfNulls(size)
        }
    }
}