package com.netcore.android.event

import androidx.annotation.IntDef
import androidx.annotation.Keep
import androidx.annotation.StringDef


/**
 * Class contains Event related constants
 */
internal class SMTEventId {

    companion object {

        // Event IDs

        const val EVENT_DEVICE_DATA_DUMP = 99
        const val EVENT_APP_INSTALLED = 20
        const val EVENT_APP_UPDATED = 81

        const val EVENT_FIRST_APP_LAUNCHED = 80
        const val EVENT_APP_LAUNCHED = 21
        const val EVENT_APP_CRASHED = 82
        const val EVENT_APP_REINSTALLED = 83
        const val EVENT_PN_TOKEN_GENERATED = 86
        const val EVENT_PN_TOKEN_FAILED = 87
        const val EVENT_PN_TOKEN_REFRESHED = 88

        const val EVENT_DEVICE_DETAILS_UPDATED = 26
        const val EVENT_LOCATION_FETCH_ENABLED = 89
        const val EVENT_LOCATION_FETCH_DISABLED = 90

        const val EVENT_PN_RENDERED = 18
        const val EVENT_PN_DELIVERED = 12
        const val EVENT_PN_CLICKED = 13
        const val EVENT_PN_DISMISSED = 14


        const val EVENT_INAPP_VIEWED = 41
        const val EVENT_INAPP_CLICKED = 42
        const val EVENT_INAPP_DISMISSED = 43

        const val EVENT_INBOX_DELIVERED = 44
        const val EVENT_INBOX_VIEWED = 45
        const val EVENT_INBOX_CLICKED = 46
        const val EVENT_INBOX_DISMISSED = 47

        const val EVENT_USER_LOGGED_IN = 22
        const val EVENT_USER_LOGGED_OUT = 23
        const val EVENT_USER_ENABLED_PN = 84
        const val EVENT_USER_DISABLED_PN = 85
        const val EVENT_USER_TRACKING_OPT_IN = 70
        const val EVENT_USER_TRACKING_OPT_OUT = 71
        const val EVENT_USER_PN_OPT_IN = 72
        const val EVENT_USER_PN_OPT_OUT = 73
        const val EVENT_USER_INAPP_OPT_IN = 74
        const val EVENT_USER_INAPP_OPT_OUT = 75
        const val EVENT_USER_PROFILE_PUSH = 40
        const val EVENT_CUSTOM = 0 // its not defined in the doc, temp value

        const val EVENT_APP_INSTALL_UPDATE_NETCORE = 999 // used to handle app install updates

        // Event Names
        fun getEventName(@SMTEventId id: Int): String {
            return when (id) {
                EVENT_DEVICE_DATA_DUMP -> "device_common_data"
                EVENT_APP_INSTALLED -> "app_installed"
                EVENT_APP_UPDATED -> "app_updated"
                EVENT_FIRST_APP_LAUNCHED -> "first_app_launched"
                EVENT_APP_LAUNCHED -> "regular_app_launched"
                EVENT_APP_CRASHED -> "app_crashed"
                EVENT_PN_TOKEN_GENERATED -> "pn_token_generated"
                EVENT_PN_TOKEN_FAILED -> "pn_token_failed"
                EVENT_PN_TOKEN_REFRESHED -> "pn_token_refreshed"
                EVENT_DEVICE_DETAILS_UPDATED -> "device_updated"
                EVENT_LOCATION_FETCH_ENABLED -> "app_location_enabled"
                EVENT_LOCATION_FETCH_DISABLED -> "app_location_disabled"
                EVENT_PN_RENDERED -> "pn_rendered"
                EVENT_PN_DELIVERED -> "pn_delivered"
                EVENT_PN_CLICKED -> "pn_clicked"
                EVENT_PN_DISMISSED -> "pn_dismissed"
                EVENT_INAPP_VIEWED -> "inapp_viewed"
                EVENT_INAPP_CLICKED -> "inapp_clicked"
                EVENT_INAPP_DISMISSED -> "inapp_closed"
                EVENT_INBOX_DELIVERED -> "inbox_delivered"
                EVENT_INBOX_VIEWED -> "inbox_viewed"
                EVENT_INBOX_CLICKED -> "inbox_clicked"
                EVENT_INBOX_DISMISSED -> "inbox_dismissed"
                EVENT_USER_LOGGED_IN -> "user_logged_in"
                EVENT_USER_LOGGED_OUT -> "user_logged_out"
                EVENT_USER_ENABLED_PN -> "user_enabled_pn"
                EVENT_USER_DISABLED_PN -> "user_disabled_pn"
                EVENT_USER_TRACKING_OPT_IN -> "user_tracking_opt_in"
                EVENT_USER_TRACKING_OPT_OUT -> "user_tracking_opt_out"
                EVENT_USER_PN_OPT_IN -> "user_pn_opt_in"
                EVENT_USER_PN_OPT_OUT -> "user_pn_opt_out"
                EVENT_USER_INAPP_OPT_IN -> "user_inapp_opt_in"
                EVENT_USER_INAPP_OPT_OUT -> "user_inapp_opt_out"
                EVENT_USER_PROFILE_PUSH -> "user_profile_push"
                EVENT_APP_REINSTALLED -> "app_reinstalled"
                EVENT_CUSTOM -> "custom_event"

                else -> ""
            }
        }

        //Hansel event names
        const val EVENT_NH_PROMPT_DISMISS = "nh_prompt_dismiss"
        const val EVENT_NH_PROMPT_SHOW = "nh_prompt_show"
        const val EVENT_NH_BRANCH_TRACKER = "nh_branch_tracker"
        const val EVENT_NH_PROMPT_SHOW_ID = 63
        const val EVENT_NH_PROMPT_DISMISS_ID = 64
        const val EVENT_NH_BRANCH_TRACKER_ID = 65

        // Get hansel event id
        fun getEventId(eventName: String): Int {
            return when (eventName) {
                EVENT_NH_PROMPT_DISMISS -> EVENT_NH_PROMPT_DISMISS_ID
                EVENT_NH_PROMPT_SHOW -> EVENT_NH_PROMPT_SHOW_ID
                EVENT_NH_BRANCH_TRACKER -> EVENT_NH_BRANCH_TRACKER_ID

                else -> 0
            }
        }
    }

    @IntDef(
            EVENT_DEVICE_DATA_DUMP,
            EVENT_APP_INSTALLED,
            EVENT_APP_UPDATED,
            EVENT_FIRST_APP_LAUNCHED,
            EVENT_APP_LAUNCHED,
            EVENT_APP_CRASHED,
            EVENT_PN_TOKEN_GENERATED,
            EVENT_PN_TOKEN_FAILED,
            EVENT_PN_TOKEN_REFRESHED,
            EVENT_DEVICE_DETAILS_UPDATED,
            EVENT_LOCATION_FETCH_ENABLED,
            EVENT_LOCATION_FETCH_DISABLED,
            EVENT_PN_RENDERED,
            EVENT_PN_DELIVERED,
            EVENT_PN_CLICKED,
            EVENT_PN_DISMISSED,
            EVENT_INAPP_VIEWED,
            EVENT_INAPP_CLICKED,
            EVENT_INAPP_DISMISSED,
            EVENT_INBOX_DELIVERED,
            EVENT_INBOX_VIEWED,
            EVENT_INBOX_CLICKED,
            EVENT_INBOX_DISMISSED,
            EVENT_USER_LOGGED_IN,
            EVENT_USER_LOGGED_OUT,
            EVENT_USER_ENABLED_PN,
            EVENT_USER_DISABLED_PN,
            EVENT_USER_TRACKING_OPT_IN,
            EVENT_USER_TRACKING_OPT_OUT,
            EVENT_USER_PN_OPT_IN,
            EVENT_USER_PN_OPT_OUT,
            EVENT_USER_INAPP_OPT_IN,
            EVENT_USER_INAPP_OPT_OUT,
            EVENT_USER_PROFILE_PUSH,
            EVENT_CUSTOM
    )

    @Retention(AnnotationRetention.SOURCE)
    annotation class SMTEventId

}

/**
 * Notification source type PN / PushAmp
 */
class SMTNotificationSourceType {
    @IntDef(NOTIFICATION_SOURCE_PN, NOTIFICATION_SOURCE_PAMP, NOTIFICATION_SOURCE_XIAOMI)
    @Retention(AnnotationRetention.SOURCE)
    annotation class Source

    @Keep
    companion object {
        const val NOTIFICATION_SOURCE_PN = 1
        const val NOTIFICATION_SOURCE_PAMP = 3
        const val NOTIFICATION_SOURCE_XIAOMI = 10
    }
}

@Suppress("unused")
/**
 * Event Sync Status
 */
internal class SMTEventSyncStatus {
    @IntDef(EVENT_SYNC_STATUS_PENDING, EVENT_SYNC_STATUS_INPROGRESS, EVENT_SYNC_STATUS_FAILED, EVENT_SYNC_STATUS_SUCCESS)
    @Retention(AnnotationRetention.SOURCE)
    annotation class Status

    internal companion object {
        const val EVENT_SYNC_STATUS_PENDING = 1
        const val EVENT_SYNC_STATUS_INPROGRESS = 2
        const val EVENT_SYNC_STATUS_SUCCESS = 3
        const val EVENT_SYNC_STATUS_FAILED = 4
    }
}

/**
 * Event type
 */
internal class SMTEventType {
    @StringDef(EVENT_TYPE_SYSTEM, EVENT_TYPE_CUSTOM)
    @Retention(AnnotationRetention.SOURCE)
    annotation class Type

    companion object {
        const val EVENT_TYPE_SYSTEM = "system"
        const val EVENT_TYPE_CUSTOM = "custom"
    }
}
