package com.netcore.android.db

import android.database.Cursor
import android.database.sqlite.SQLiteDatabase

/**
 * Copyright © 2019 Netcore. All rights reserved.
 *
 * Abstract DB Table, all tables has to extends this
 * Contains all operation methods
 *
 * @see SMTDataBaseWrapper for method definitions
 *
 * @author Netcore
 * @version 1.0
 * @since 26-02-2019
 */
internal abstract class SMTDBTable(private val dbWrapper: SMTDataBaseWrapper) {

    open fun upgradeTable(oldVersion: Int, newVersion: Int) {
//        Logger.d(this.javaClass.simpleName, "upgrade Database Callback.")
    }

    internal fun executeQuery(query: String) {
        dbWrapper.execSQL(query)
    }

    internal fun executeRawQuery(query: String, args: Array<String>?): Cursor? {
        return dbWrapper.rawQuery(query, args)
    }

    internal fun executeRawQuery(query: String): Cursor? {
        return dbWrapper.rawQuery(query, null)
    }

    internal fun deleteTableData(tableName: String) {
        dbWrapper.delete(tableName, null, null)
    }

    internal fun getDatabase(): SQLiteDatabase? {
        return dbWrapper.getDatabase()
    }

    abstract fun createTable()

}