package com.netcore.android.notification

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import com.netcore.android.logger.SMTLogger

/**
 * Copyright © 2019 Netcore. All rights reserved.
 *
 * Handles the incoming notification
 *
 * @author Netcore
 * @version 1.0
 * @since 26-02-2019
 */

class SMTBootPNReceiver : BroadcastReceiver() {
    val TAG = SMTBootPNReceiver::class.java.simpleName

    override fun onReceive(context: Context?, intent: Intent?) {
        if (context != null) {
            SMTLogger.d(TAG, "On Boot Receiver called")
            SMTScheduleNotification().onBootComplete(context)
        }
    }
}
