package com.netcore.android.network.models

import com.netcore.android.SMTConfigConstants

/**
 * @Description
 *
 * PushAmp Response Model class
 *
 * @author Netcore
 * @version 1.0
 * @since 20-03-2019
 */


internal class SMTPushAmpResponse : SMTResponse() {
    var pushAmpData: PushAmpData? = null

    class PushAmpData {
        var paEnabled = SMTConfigConstants.DEFAULT_IS_PUSH_AMP_ENABLED
        var paInterval = SMTConfigConstants.DEFAULT_PUSH_AMP_INTERVAL
        lateinit var notificationString: ArrayList<String>
        var scheduledNotification: ArrayList<String>? = null
        var removeScheduledNotification: ArrayList<String>? = null

        override fun toString(): String {
            return "PushAmpData(paEnabled=$paEnabled, paInterval=$paInterval, notificationString=$notificationString)"
        }

    }

    override fun toString(): String {
        return "SMTPushAmpResponse(pushAmpData=$pushAmpData)"
    }


}