package com.netcore.android.inbox.utility;

import androidx.annotation.IntDef;
import androidx.annotation.Keep;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class SMTInboxMessageType {

    @Keep
    @IntDef({Type.ALL_MESSAGE, Type.INBOX_MESSAGE, Type.READ_MESSAGE, Type.UNREAD_MESSAGE})
    @Retention(RetentionPolicy.SOURCE)

    public @interface Type {
        int ALL_MESSAGE = 1; // for all inbox messages
        int INBOX_MESSAGE = 2; // for all inbox messages except dismissed
        int READ_MESSAGE = 3; // For all inbox messages status is clicked
        int UNREAD_MESSAGE = 4; // for all inbox messages except clicked, and dismissed
    }
}
