package com.netcore.android.inapp

import android.content.Intent
import android.net.Uri
import android.webkit.JavascriptInterface
import com.netcore.android.event.SMTEventId
import com.netcore.android.inapp.model.SMTInAppRule
import com.netcore.android.logger.SMTLogger
import com.netcore.android.utility.SMTCommonUtility

@Suppress("unused", "UNUSED_PARAMETER")
internal class SMTInAppJavaScriptInterface(private var inAppRule: SMTInAppRule, private val closeActionListener: SMTInAppRuleActionListener, private val inAppCustomHtmlListener: InAppCustomHTMLListener?) {


    private var isRecordInAppDismissEent = true
    private val TAG = SMTInAppJavaScriptInterface::class.java.simpleName

    @JavascriptInterface
    fun intentAction(url: String, payload: String?) {

        var finalUrl = url
        if (finalUrl.isNotEmpty()) {

            recordIntentAction(url)

            if (finalUrl.matches("sms:[0-9]*.&body=(?s:.)*".toRegex())) {
                finalUrl = finalUrl.replace("&body".toRegex(), "\\?body")
            }

            try {
                if (inAppCustomHtmlListener != null) {
                    SMTInAppUtility.processInAppCustomHtmlData(inAppCustomHtmlListener, payload)
                }
                val i = Intent(Intent.ACTION_VIEW, Uri.parse(finalUrl))
                SMTInAppUtility.getForeGroundActivity()?.startActivity(i)
            } catch (e: Exception) {
                SMTLogger.e(TAG, e.message.toString())
            }
            isRecordInAppDismissEent = false
            closeAction("")

        } else {
            isRecordInAppDismissEent = false
        }
    }

    /**
     * Record intentAction event
     */
    private fun recordIntentAction(url: String) {
        SMTInAppUtility.getForeGroundActivity()?.let {
            SMTCommonUtility.updateAttributionParams(it.applicationContext, url)
            closeActionListener.recordInAppEvent(SMTEventId.EVENT_INAPP_CLICKED, inAppRule, url)
        }
    }

    @JavascriptInterface
    fun closeAction(value: String) {
        closeActionListener.closeActionClicked(isRecordInAppDismissEent)
    }
}