package com.netcore.android.preference

/**
 * Copyright © 2019 Netcore. All rights reserved.
 *
 * SingleTon class holds preference related keys
 *
 * @author Netcore
 * @version 1.0
 * @since 26-02-2019
 */

internal object SMTPreferenceConstants {
    /**
     * Shared Preferene name
     */
    const val PREFERENCE_NAME = "smartech"

    /**
     * Event batch processing
     */
    const val LAST_BATCH_EXECUTION_TIME = "LastBatchExecutionTime"
//    const val BatchExecutionJobStarted="BatchExecutionJobStarted"

    /**
     * Smartech setting constants
     */
    const val BATCH_INTERVAL = "batchInterval"
    const val BATCH_SIZE = "batchSize"
    const val IS_FETCH_LOCATION_ENABLED = "fetchLocation"
    const val IS_PUSH_AMP_ENABLED = "paEnabled"
    const val PUSH_AMP_INTERVAL = "paInterval"
    const val IS_PANEL_ACTIVE = "panelActive"
    const val IS_SDK_ACTIVE = "sdkActive"
    const val SESSION_INTERVAL = "sessionInterval"
    const val TOKEN_INTERVAL = "tokenInterval"
    const val EVENT_LIMIT = "eventLimit"

    /**
     * application session id
     */
    const val CURRENT_SESSION_ID = "current_session_id"

    /**
     * application session id
     */
    const val LAST_APP_ACTIVE_TIME_STAMP = "last_app_active_time_stamp"

    /**
     * current push token
     */
    const val PUSH_TOKEN_CURRENT = "push_token_current"

    /**
     * OLD push token
     */
    const val PUSH_TOKEN_OLD = "push_token_old"

    /**
     *  Current push token FCM
     */
    const val FCM_PUSH_TOKEN_CURRENT = "fcm_push_token_current"

    /**
     *  Old push token FCM
     */
    const val FCM_PUSH_TOKEN_OLD = "fcm_push_token_old"

    /**
     * FIRST LAUNCH
     */
    const val SMT_IS_FIRST_LAUNCH = "is_first_launch"

    /**
     * Last known Latitude and Longitude
     */
    const val SMT_LAST_KNOWN_LATITUDE = "last_known_latitude"
    const val SMT_LAST_KNOWN_LONGITUDE = "last_known_longitude"

    /**
     * Following params used to check UDD(update device details)
     */
    const val SMT_OS_VERSION = "os_version"
    const val SMT_APP_VERSION = "app_version"
    const val SMT_APP_VERSION_CODE = "version_code"
    const val SMT_SDK_VERSION = "sdk_version"
    const val SMT_CARRIER = "carrier"
    const val SMT_DEVICE_LOCALE = "deviceLocale"
    const val SMT_ADID = "adid"
    const val SMT_TIMEZONE = "timezone"
    const val SMT_IS_APP_INSTALL_UPDATE_BY_SMARTECH = "is_app_install_update_by_smartech"
    const val IS_SMRATECH_SETTINGS_STORED = "is_smartech_settings_stored"

    const val OPT_IN_OUT_TRACKING = "opt_in_out_tracing"
    const val OPT_IN_OUT_PUSH_NOTIFICATION = "opt_in_out_pn"
    const val OPT_IN_OUT_IN_APP_MESSAGES = "opt_in_out_in_app"

    const val PUSH_AMP_TASK_COUNT = "push_amp_alarm_count" // used to increase PAMP time interval exponentially
    const val JOB_SCHEDULER_JOB_ID = "job_scheduler_job_id"
    const val LAST_ALARM_RECEIVED_TIME = "last_alarm_received_time"

    const val SMT_MF_IS_USE_AD_ID = "is_use_ad_id" // MF = Manifest
    const val SMT_MF_APP_ID = "app_id" // MF = Manifest
    const val SMT_MF_IS_AUTO_FETCH_LOCATION = "is_auto_fetch_location" // MF = Manifest
    const val SMT_MF_IS_AUTO_FETCH_INBOX_MESSAGE = "is_auto_fetch_location_inbox" // MF = Manifest
    const val SMT_MF_IS_NOTIFICATION_LISTENER_ENABLED = "is_notification_listener_enabled" // MF = Manifest
    const val SMT_MF_SDK_V2_CONFIG_ON_UPDATE = "is_sdk_v2_config_on_update" // MF = Manifest

    const val SMT_DEBUG_LEVEL = "smt_debug_level"
    const val SMT_USER_IDENTITY = "smt_user_identity"
    const val SMT_USER_OLD_IDENTITY = "smt_user_old_identity" // will be used for late bind
    const val SMT_USER_PROFILE_MD5_HASH = "smt_user_profile_md5_hash" /* DE-DUP PROFILE BLOCK 1 of 4 */
    const val SMT_NOTIFICATION_IDENTITY = "smt_notification_identity"
    const val SMT_NOTIFICATION_PERMISSION = "smt_notification_permission"
    const val SMT_LOCATION_PERMISSION = "smt_location_permission"
    const val SMT_IS_LOCATION_PERMISSION_AVAILABLE = "smt_is_location_permission_available"
    const val SMT_ATTRIBUTION_PARAMS = "smt_attri_params"
    const val SMT_OTHER_ATTRIBUTION_PARAMS = "smt_other_attri_params"
    const val SMT_BASE_URL: String = "SMT_BASE_URL"


    const val SMT_BASE_URL_PUSHAMP: String = "SMT_BASE_URL_PUSHAMP"
    const val SMT_BASE_URL_TRACKAPPACT: String = "SMT_BASE_URL_TRACKAPPACT"
    const val SMT_BASE_URL_INAPP: String = "SMT_BASE_URL_INAPP"
    const val SMT_BASE_URL_INBOX: String = "SMT_BASE_URL_INBOX"
    const val SMT_BASE_URL_INAPP_LIST_SEG: String = "SMT_BASE_URL_INAPP_LIST_SEG"

    // this is used to retain attribution param in case when app is launched onclick of notification
    const val IS_LAUNCHED_FROM_NOTIFICATION = "is_launched_from_notification"
    const val SMT_NOTIFICATION_OPTION = "notification_options"
    const val SMT_GUID = "smt_guid"
    const val IS_SMT_GUID_STORED_PREVIOUSLY = "smt_guid_stored_previously"

    //    const val IS_APP_INSTALLED = "is_app_installed"
    const val SMT_PA_REQUEST_TIME = "smt_pa_request_time"

    // InApp
    const val SMT_CG = "smt_cg"
    const val SMT_MID = "smt_mid"
    const val SMT_CG_RANDOM = "smt_cg_random"
    const val SMT_CG_RULE = "smt_cg_rule"
    const val SMT_LIST_SEGMENT_DATA = "smt_list_segment_data"
    const val SMT_INAPP_ME_POS = "smt_inapp_me_pos"
    const val SMT_INAPP_WAIT_TIME = "smt_inapp_wait_time"

    // Deactivate
    const val SMT_SDK_INIT_TIMESTAMP = "smt_sdk_init_timestamp"

    // Backup GUID
    const val PREFERENCE_NAME_GUID = "smt_preferences_guid"

    //debug level
    const val IS_LOG_ENABLED = "log_enable"
    const val LOG_LEVEL = "log_level"
    const val GUIDS = "guids"

    // PN Token Timestamp
    const val PN_TOKEN_TIMESTAMP = "pn_token_timestamp"

    // fcm disable
    const val IS_FCM_DISABLED = "is_fcm_disabled"

    // existing Sharedpreferences from old SDK
    const val OLD_SDK_GUID_PREFERENCES_FILE_NAME = "smt_guid_preferences"
    const val OLD_SDK_PUSHID = "pushId"
    const val OLD_SDK_TOKEN = "regId"
    const val OLD_SDK_PREFERENCES_FILE_NAME = "NetcorePrefsFile"
    const val OLD_SDK_IDENTITY = "identity"
    const val OLD_SDK_READ_STATUS = "old_sdk_read_status"
    const val UPDATED_FROM_LEGACY_SDK = "updated_from_legacy_sdk"

}