package com.netcore.android.event

import android.content.Context
import com.netcore.android.SMTConfigConstants
import com.netcore.android.SMTEventParamKeys
import com.netcore.android.logger.SMTLogger
import com.netcore.android.preference.SMTPreferenceConstants
import com.netcore.android.preference.SMTPreferenceHelper
import com.netcore.android.utility.SMTCommonUtility
import com.netcore.android.utility.SMTGWSource
import com.netcore.android.utility.SMTInfo
import org.json.JSONArray
import org.json.JSONObject
import java.lang.ref.WeakReference

/**
 * Copyright © 2019 Netcore. All rights reserved.
 *
 * This is the base class for creating event payload, all event payload class has to override this class
 *
 * @author Netcore
 * @version 1.0
 * @since 11-03-2019
 */
@Suppress("unused")
internal class SMTEventCommonDataDump(context: Context) {
    private val TAG = SMTEventCommonDataDump::class.java.simpleName
    private var appVersion: String
    private var sdkVersion: String
    private var osName: String
    private var deviceMake: String
    private var deviceModel: String
    private var adId: String
    private var appId: String
    private var pushId: String
    private var pushTokenOld: String
    private var appBuid: String
    private var appBundleId: String
    private var osVersion: String
    private var carrier: String
    private var countryCode: String
    private var radio: String
    private var vendorId: String = ""
    private var deviceWidth: String
    private var deviceHeight: String
    private var useAdvId: String
    private var pushTokens: JSONArray = JSONArray()
    private var bod: Int
    private var eventId: String
    private var eventName: String
    private var eventTime: String
    private var guid: String
    private var deviceLocale: String


    protected val mSmtInfo = SMTInfo.getInstance(WeakReference(context))

    init {

        appVersion = mSmtInfo.mAppInfo?.appVersion ?: ""
        osName = mSmtInfo.mDeviceInfo?.osName ?: SMTConfigConstants.OS_NAME
        deviceMake = mSmtInfo.mDeviceInfo?.deviceMake ?: ""
        deviceModel = mSmtInfo.mDeviceInfo?.deviceModel ?: ""
        adId = mSmtInfo.mDeviceInfo?.advertiserId ?: ""
        appBuid = mSmtInfo.mAppInfo?.appBuild ?: ""
        appId = mSmtInfo.mAppInfo?.manifestConfig?.appId ?: ""
        pushId = SMTPreferenceHelper.getAppPreferenceInstance(context, null).getString(SMTPreferenceConstants.PUSH_TOKEN_CURRENT)
        pushTokenOld = SMTPreferenceHelper.getAppPreferenceInstance(context, null).getString(SMTPreferenceConstants.PUSH_TOKEN_OLD)
        appBuid = mSmtInfo.mAppInfo?.appBuild ?: ""
        appBundleId = mSmtInfo.mAppInfo?.appBundleId ?: ""
        osVersion = mSmtInfo.mDeviceInfo?.osVersion ?: ""
        carrier = mSmtInfo.mNetworkInfo?.carrier ?: ""
        countryCode = mSmtInfo.mNetworkInfo?.countryCode ?: ""
        radio = mSmtInfo.mNetworkInfo?.radio ?: ""
        deviceWidth = mSmtInfo.mDeviceInfo?.deviceWidth ?: ""
        deviceHeight = mSmtInfo.mDeviceInfo?.deviceHeight ?: ""
        useAdvId = mSmtInfo.mAppInfo?.manifestConfig?.useADID.toString()
        pushTokens = getPushTokensArray(context, pushId, pushTokenOld)
        bod = SMTCommonUtility.getBOD(context)
        eventId = SMTEventId.EVENT_DEVICE_DATA_DUMP.toString()
        eventName = SMTEventId.getEventName(SMTEventId.EVENT_DEVICE_DATA_DUMP)
        eventTime = System.currentTimeMillis().toString()
        guid = mSmtInfo.mDeviceInfo?.guid ?: ""
        deviceLocale = mSmtInfo.mDeviceInfo?.deviceLocale ?: ""
        sdkVersion = mSmtInfo.mAppInfo?.smtSdkVersion ?: ""
        vendorId = ""
    }

    /**
     * provides the Map of event payload
     * @return map of events
     */
    fun getPayloadParams(): HashMap<String, Any?> {
        val hashMap = HashMap<String, Any?>()
        hashMap[SMTEventParamKeys.SMT_APP_VERSION] = appVersion
        hashMap[SMTEventParamKeys.SMT_SDK_VERSION] = sdkVersion
        hashMap[SMTEventParamKeys.SMT_OS_NAME] = osName
        hashMap[SMTEventParamKeys.SMT_DEVICE_MAKE] = deviceMake
        hashMap[SMTEventParamKeys.SMT_DEVICE_MODEL] = deviceModel
        hashMap[SMTEventParamKeys.SMT_AD_ID] = adId
        hashMap[SMTEventParamKeys.SMT_APP_ID] = appId
        hashMap[SMTEventParamKeys.SMT_PUSH_TOKEN_CURRENT] = pushId
        hashMap[SMTEventParamKeys.SMT_PUSH_TOKEN_OLD] = pushTokenOld
        hashMap[SMTEventParamKeys.SMT_PUSH_TOKENS] = pushTokens
        hashMap[SMTEventParamKeys.SMT_APP_BUILD] = appBuid
        hashMap[SMTEventParamKeys.SMT_APP_BUNDLE_ID] = appBundleId
        hashMap[SMTEventParamKeys.SMT_OS_VERSION] = osVersion
        hashMap[SMTEventParamKeys.SMT_CARRIER] = carrier
        hashMap[SMTEventParamKeys.SMT_COUNTRY_CODE] = countryCode
        hashMap[SMTEventParamKeys.SMT_RADIO] = radio
        hashMap[SMTEventParamKeys.SMT_DEVICE_WIDTH] = deviceWidth
        hashMap[SMTEventParamKeys.SMT_DEVICE_HEIGHT] = deviceHeight
        hashMap[SMTEventParamKeys.SMT_USE_ADV_ID] = useAdvId == "1"
//        hashMap[SMTEventParamKeys.SMT_DEVICE_UID] = deviceUid
        hashMap[SMTEventParamKeys.SMT_BOD] = bod
        hashMap[SMTEventParamKeys.SMT_EVENT_ID] = eventId // Need to check whether it can be made as common param
        hashMap[SMTEventParamKeys.SMT_EVENT_NAME] = eventName
        hashMap[SMTEventParamKeys.SMT_EVENT_TIME] = eventTime
        hashMap[SMTEventParamKeys.SMT_EVENT_TIME] = eventTime
        hashMap[SMTEventParamKeys.SMT_GUID] = guid
        hashMap[SMTEventParamKeys.SMT_DEVICE_LOCALE] = deviceLocale
        hashMap[SMTEventParamKeys.SMT_VENDOR_ID] = vendorId

        return hashMap
    }

    /**
     *  This method will provide common parameters for
     *  all URL's
     *  @param context App context
     *  @return string
     */
    fun getURLParameters(): String {
        return "${SMTEventParamKeys.SMT_APP_ID}=$appId&${SMTEventParamKeys.SMT_APP_VERSION}=$appVersion&${SMTEventParamKeys.SMT_SDK_VERSION}=$sdkVersion"
    }

    /**
     *  This method will return AppBundleId
     */
    fun getAppBundleId(): String {
        return this.appBundleId
    }

    private fun getPushTokensArray(context: Context, currentToken: String, oldToken: String): JSONArray {

        val objPushTokensArray = JSONArray()
        try {

            val objFCM = JSONObject()
            objFCM.put("gwSource", SMTGWSource.FCM.value)
            objFCM.put("pushToken", currentToken)
            objFCM.put("pushTokenOld", oldToken)
            objPushTokensArray.put(objFCM)

        } catch (e: Exception) {
            SMTLogger.e(TAG, e.message.toString())
        }
        return objPushTokensArray
    }
}