package com.netcore.android.preference

import android.content.Context
import android.content.SharedPreferences
//import com.fasterxml.jackson.core.JsonProcessingException
//import com.fasterxml.jackson.databind.ObjectMapper
import java.util.concurrent.atomic.AtomicBoolean

/**
 * It is  a Preference Helper but is given the job to read and write the data from android shared preferences.
 *
 * @author Netcore
 * @version 1.0
 * @since 26-02-2019
 */
class SMTGUIDPreferenceHelper private constructor(context: Context) : SMTPreferenceInterface {

    private val mPrefs: SharedPreferences = context.getSharedPreferences(mPrefFileName, Context.MODE_PRIVATE)

    private val mEditor: SharedPreferences.Editor = mPrefs.edit()

    override fun getLong(key: String): Long {
        return mPrefs.getLong(key, 0)
    }

    override fun getLong(key: String, defaultValue: Long): Long {
        return mPrefs.getLong(key, defaultValue)
    }

    override fun setLong(key: String, value: Long) {
        mEditor.putLong(key, value)
        mEditor.apply()
    }

    override fun getDouble(key: String): Double {
        return java.lang.Double.longBitsToDouble(getLong(key))
    }

    override fun setDouble(key: String, value: Double) {
        mEditor.putLong(key, java.lang.Double.doubleToRawLongBits(value))
        mEditor.apply()
    }

    override fun setInt(key: String, value: Int) {
        setString(key, value.toString())
    }

    override fun getInt(key: String): Int {
//        val encryptedValue = mPrefs.getString(encrypt(key), encrypt("0"))
//        return decrypt(encryptedValue)?.toInt()
        return mPrefs.getString(key, "-1")?.toInt() ?: -1
    }

    override fun getInt(key: String, defaultValue: Int): Int {
//        val encryptedValue = mPrefs.getString(encrypt(key), encrypt("$defaultValue"))
//        return decrypt(encryptedValue).toInt()
        return mPrefs.getString(key, "$defaultValue")?.toInt() ?: -1
    }

    override fun setBoolean(key: String, value: Boolean) {
        mEditor.putBoolean(key, value)
        mEditor.apply()
    }

    override fun getBoolean(key: String): Boolean {
        return mPrefs.getBoolean(key, false)
    }

    override fun setString(key: String, value: String) {
        mEditor.putString(encrypt(key), encrypt(value))
        mEditor.apply()
    }

    override fun getString(key: String): String {
        val encryptedValue = mPrefs.getString(encrypt(key), encrypt("")) ?: ""
        return decrypt(encryptedValue)
    }

    override fun getString(key: String, value: String): String {
        val encryptedValue = mPrefs.getString(encrypt(key), encrypt(value)) ?: ""
        return decrypt(encryptedValue)
    }

    /*override fun getObject(key: String, className: Class<*>): Any? {
        try {
            val json = mPrefs.getString(key, "")
            if (TextUtils.isEmpty(json)) {
                return null
            }
            val mapper = ObjectMapper()
            return mapper.readValue(json, className)
        } catch (e: Exception) {
            e.printStackTrace()
            return null
        }
    }

    override fun setObject(key: String, o: Any) {
        val mapper = ObjectMapper()
        try {
            val json = mapper.writeValueAsString(o)
            mEditor.putString(key, json)
            mEditor.apply()
        } catch (e: JsonProcessingException) {
            e.printStackTrace()
        }
    }*/

    override fun getObjectInString(key: String): String {
        return mPrefs.getString(key, "") ?: ""
    }

    override fun removePrefValue(key: String) {
        mEditor.remove(key).commit()
    }

    override fun setFloat(key: String, value: Float) {
        mEditor.putFloat(key, value)
        mEditor.apply()
    }

    override fun getFloat(key: String): Float {
        return mPrefs.getFloat(key, 0f)
    }

    override fun getBoolean(key: String, defaultValue: Boolean): Boolean {
        return mPrefs.getBoolean(key, defaultValue)
    }

    fun encrypt(input: String): String {
//        val encryption = Encryption.getDefault(BuildConfig.SCRTK,BuildConfig.SALTK , ByteArray(16))
//        return encryption?.encryptOrNull(input)!!
        return input
    }

    fun decrypt(input: String): String {
//        val encryption = Encryption.getDefault(BuildConfig.SCRTK,BuildConfig.SALTK , ByteArray(16))
//        return encryption?.decryptOrNull(input)!!
        return input
    }

    companion object {
        private var mPrefFileName = SMTPreferenceConstants.PREFERENCE_NAME_GUID
        private lateinit var INSTANCE: SMTGUIDPreferenceHelper
        private val initialized = AtomicBoolean()

        @Synchronized
        fun getAppPreferenceInstance(context: Context, prefFileName: String?): SMTGUIDPreferenceHelper {
            if (!prefFileName.isNullOrEmpty()) {
                mPrefFileName = prefFileName!!
            }
            if (!initialized.getAndSet(true)) {
                INSTANCE = SMTGUIDPreferenceHelper(context)
            }
            return INSTANCE
        }
    }
}
