package com.netcore.android.network.parser

import com.netcore.android.SMTConfigConstants
import com.netcore.android.inapp.SMTInAppRuleParser
import com.netcore.android.logger.SMTLogger
import com.netcore.android.network.SMTHttpRequestClient
import com.netcore.android.network.models.SMTSdkInitializeResponse
import org.json.JSONObject

/**
 * @author Netcore
 * created on 26/02/2019
 * @Description: SDK Initialization response parser
 */
internal class SMTSdkInitParser {

    internal fun parse(networkResponse: SMTHttpRequestClient.NetworkResponse): SMTSdkInitializeResponse {

        var sdkInitResponse = SMTSdkInitializeResponse()
        sdkInitResponse.smtApiTypeID = networkResponse.apiID
        try {

            if (networkResponse.response == null) {
                SMTLogger.w("SMTSdkInitParser", " Init api response is null.")
                return sdkInitResponse
            }

            val jsonObject = networkResponse.response?.let {
                JSONObject(networkResponse.response)
            } ?: JSONObject()

            try {
                sdkInitResponse.smartechSettings = SMTSdkInitializeResponse.SmartTechSettings()

                val smartTechSettingJson = jsonObject.optJSONObject("smartechSettings")

                try {
                    var batchInterval = smartTechSettingJson.optInt("batchInterval")
                    if (batchInterval < 5) {
                        batchInterval = 5
                    }
                    sdkInitResponse.smartechSettings?.batchInterval = batchInterval

                } catch (e: Exception) {
                    e.printStackTrace()
                }

                try {
                    var batchSize = smartTechSettingJson.optInt("batchSize")
                    if (batchSize < 1) {
                        batchSize = 1
                    }
                    sdkInitResponse.smartechSettings?.batchSize = batchSize
                } catch (e: Exception) {
                    e.printStackTrace()
                }

                try {

                    sdkInitResponse.smartechSettings?.fetchLocation = smartTechSettingJson.optBoolean("fetchLocation")
                } catch (e: Exception) {
                    e.printStackTrace()
                }

                try {

                    sdkInitResponse.smartechSettings?.paEnabled = smartTechSettingJson.optBoolean("paEnabled")
                } catch (e: Exception) {
                    e.printStackTrace()
                }

                try {

                    sdkInitResponse.smartechSettings?.paInterval = smartTechSettingJson.optInt("paInterval")
                } catch (e: Exception) {
                    e.printStackTrace()
                }

                try {

                    sdkInitResponse.smartechSettings?.panelActive = smartTechSettingJson.optBoolean("panelActive")
                } catch (e: Exception) {
                    e.printStackTrace()
                }

                try {

                    sdkInitResponse.smartechSettings?.sdkActive = smartTechSettingJson.optBoolean("sdkActive")
                } catch (e: Exception) {
                    e.printStackTrace()
                }

                try {

                    sdkInitResponse.smartechSettings?.sessionInterval = smartTechSettingJson.optInt("sessionInterval")
                } catch (e: Exception) {
                    e.printStackTrace()
                }

                try {
                    sdkInitResponse.smartechSettings?.baseUrl = smartTechSettingJson.optString("baseUrl")
                } catch (e: Exception) {
                    e.printStackTrace()
                }

                // Parsing Token Frequency
                try {
                    var tokenInterval = smartTechSettingJson.optInt("tokenInterval")
                    if (tokenInterval < 1) {
                        tokenInterval = SMTConfigConstants.DEFAULT_TOKEN_INTERVAL
                    }
                    sdkInitResponse.smartechSettings?.tokenInterval = tokenInterval
                } catch (e: Exception) {
                    e.printStackTrace()
                }

                // Parsing base URL
                try {
                    sdkInitResponse.smartechSettings?.smartechURL = SMTSdkInitializeResponse.SmartTechSettings.SmartTechBaseURL()
                    val objURL = smartTechSettingJson.optJSONObject("baseUrls")
                    objURL?.let {
                        sdkInitResponse.smartechSettings?.smartechURL?.trackAppActUrl = it.optString("trackAppActUrl")
                        sdkInitResponse.smartechSettings?.smartechURL?.pushAmpUrl = it.optString("pushAmpUrl")
                        sdkInitResponse.smartechSettings?.smartechURL?.inAppUrl = it.optString("inAppUrl")
                        sdkInitResponse.smartechSettings?.smartechURL?.inboxUrl = it.optString("inboxUrl")
                    }

                } catch (e: java.lang.Exception) {
                    e.printStackTrace()
                }
                // Parsing debug level
                try {
                    sdkInitResponse.smartechSettings?.debuglevel = SMTSdkInitializeResponse.SmartTechSettings.SmartTechDebugLevel()
                    val objURL = smartTechSettingJson.optJSONObject("debug")
                    objURL?.let {
                        sdkInitResponse.smartechSettings?.debuglevel?.logEnabled = it.optBoolean("logEnabled", false)
                        sdkInitResponse.smartechSettings?.debuglevel?.logLevel = it.optInt("logLevel", 0)
                        sdkInitResponse.smartechSettings?.debuglevel?.guids = it.optJSONArray("guids")
                    }

                } catch (e: java.lang.Exception) {
                    e.printStackTrace()
                }


            } catch (e: Exception) {
                e.printStackTrace()
            }
            try {
                // InAppRule parsing here

                val inAppRuleList = jsonObject.getJSONArray("InAppRuleList")
                if (inAppRuleList != null && inAppRuleList.length() > 0) {

                    sdkInitResponse.inAppRules = ArrayList()
                    for (i in 0..(inAppRuleList.length() - 1)) {

                        sdkInitResponse.inAppRules!!.add(SMTInAppRuleParser().parseRule(inAppRuleList.get(i) as JSONObject))

                    }
                }

                // parsing newInAppRules from inAppRules payload
                val newInAppRuleList = jsonObject.optJSONArray("newInAppRules")
                if (newInAppRuleList != null && newInAppRuleList.length() > 0) {
                    if (sdkInitResponse.inAppRules == null) {
                        sdkInitResponse.inAppRules = ArrayList()
                    }
                    for (i in 0..(newInAppRuleList.length() - 1)) {

                        sdkInitResponse.inAppRules!!.add(SMTInAppRuleParser().parseRule(newInAppRuleList.get(i) as JSONObject))

                    }
                }

            } catch (e: Exception) {
                e.printStackTrace()
            }

        } catch (e: Exception) {
            e.printStackTrace()
        }


        return sdkInitResponse
    }

}