package com.netcore.android.network.parser

import com.netcore.android.logger.SMTLogger
import com.netcore.android.network.SMTHttpRequestClient
import com.netcore.android.network.models.SMTPushAmpResponse
import org.json.JSONArray
import org.json.JSONObject

/**
 * @Description
 *
 * PushAmp Job Response parser class
 *
 * @author Netcore
 * @version 1.0
 * @since 20-03-2019
 */

internal class SMTPushAmpParser {
    private val KEY_PUSH_AMP_DATA = "pushAmpData"
    private val KEY_PUSH_AMP_ENABLED = "pa_enable"
    private val KEY_PUSH_AMP_INTERVAL = "pa_freq"
    private val KEY_PUSH_AMP_NOTIFICAIONS = "notifications"

    internal fun parse(networkResponse: SMTHttpRequestClient.NetworkResponse): SMTPushAmpResponse {

        var pushAmpResponse = SMTPushAmpResponse()

        // If response is null then return default SMTPushAmpResponse
        if (networkResponse.response == null) {
            SMTLogger.v("SMTPushAmpParser", "PushAmp response is null")
            return pushAmpResponse
        }

        pushAmpResponse.smtApiTypeID = networkResponse.apiID
        try {
            val pushAmpData = JSONObject(networkResponse.response)

            try {

                pushAmpResponse.pushAmpData = SMTPushAmpResponse.PushAmpData()

                try {
                    val paValue = pushAmpData.optInt(KEY_PUSH_AMP_ENABLED, 0)
                    pushAmpResponse.pushAmpData?.paEnabled = when (paValue) {
                        1 -> true
                        0 -> false
                        else -> false
                    }
                } catch (e: Exception) {
                    e.printStackTrace()
                }

                try {
                    pushAmpResponse.pushAmpData?.paInterval = pushAmpData.optInt(KEY_PUSH_AMP_INTERVAL)
                } catch (e: Exception) {
                    e.printStackTrace()
                }

                try {

                    val jsonArrayNotifications: JSONArray = pushAmpData.getJSONArray(KEY_PUSH_AMP_NOTIFICAIONS)
                    val notifList = ArrayList<String>()
                    if (jsonArrayNotifications.length() > 0) {
                        for (i in 0 until jsonArrayNotifications.length()) {
                            val item = jsonArrayNotifications.get(i)
                            notifList.add(item.toString())
                        }
                    }
                    pushAmpResponse.pushAmpData?.notificationString = notifList
                } catch (e: Exception) {
                    e.printStackTrace()
                }

            } catch (e: Exception) {
                e.printStackTrace()
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return pushAmpResponse
    }
}

