package com.netcore.android.network.parser

import com.netcore.android.event.SMTNotificationSourceType
import com.netcore.android.network.SMTHttpRequestClient
import com.netcore.android.network.models.SMTInboxResponse
import com.netcore.android.notification.SMTNotificationParser
import com.netcore.android.utility.SMTCommonUtility
import org.json.JSONObject

/**
 * @Description
 *
 * Inbox Response Parser Class
 *
 * @author Netcore
 * @version 1.0
 * @since 27-04-2019
 */
internal class SMTInboxParser {

    private val KEY_INBOX_NOTIFICAIONS = "inbox"

    internal fun parse(networkResponse: SMTHttpRequestClient.NetworkResponse): SMTInboxResponse? {

        var inboxResponse = SMTInboxResponse()
        inboxResponse.smtApiTypeID = networkResponse.apiID
        try {
            val inboxData = JSONObject(networkResponse.response)

            try {
                val inboxArray = inboxData.getJSONArray(KEY_INBOX_NOTIFICAIONS)
                if (inboxArray .length() > 0) {
                    val notifList = ArrayList<SMTInboxResponse.InboxResponse>()
                    for (i in 0 until inboxArray .length()) {
                        val item = inboxArray .get(i)
                        val notifData = SMTNotificationParser().parse(item.toString(), SMTNotificationSourceType.NOTIFICATION_SOURCE_PAMP)
                        val inboxObj = SMTInboxResponse.InboxResponse()
                        inboxObj.payload = item.toString()
                        inboxObj.status = notifData?.mStatus ?: ""
                        inboxObj.trid = notifData?.mTrid ?: ""
                        inboxObj.timeStamp = SMTCommonUtility.convertStringDatetoTimeStamp(notifData?.mPublishedTimeStamp)

                        if(inboxObj.trid.isNotEmpty()) {
                            notifList.add(inboxObj)
                        }
                    }
                    inboxResponse.inboxResponse = notifList
                }
            } catch (e: Exception) {
                e.printStackTrace()
            }
        } catch (e: Exception) {
                e.printStackTrace()
            }
        return inboxResponse
    }
}