package com.nearform.patrun;

import java.util.Map;

/**
 *  Represents a data Node within the patrun decision tree
 */
public class Pattern {
    private Map<String, String> match;
    private Object data;
    private Modifier modifier;

    /**
     * Construct an instance of Pattern
     * <p>
     *
     * @param  pat  the pattern for this node
     * @param  data the data store for this pattern
     * @poaram modifier a custom modifier stored at the node
     */
    public Pattern(Map<String, String> pattern, Object data, Modifier modifier) {
        this.match = pattern;
        this.data = data;
        this.modifier = modifier;
    }

    /**
     * Get the data object for this item
     * <p>
     *
     * @return   the data object
     */
    public Object getData() {
        return this.data;
    }

    /**
     * Get the custom modifier for this item
     * <p>
     *
     * @return   the custom modifier object
     */
    public Modifier getModifier() {
        return this.modifier;
    }

    /**
     * Get the pattern for this item
     * <p>
     *
     * @return the pattern Map
     */
    public Map<String, String> getMatch() {
        return this.match;
    }
}
