/*
 * Decompiled with CFR 0.152.
 */
package com.ncapdevi.fragnav;

import android.os.Bundle;
import android.support.annotation.CheckResult;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.util.Pair;
import android.view.View;
import com.ncapdevi.fragnav.FragNavTransactionOptions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.json.JSONArray;

public class FragNavController {
    public static final int NO_TAB = -1;
    public static final int TAB1 = 0;
    public static final int TAB2 = 1;
    public static final int TAB3 = 2;
    public static final int TAB4 = 3;
    public static final int TAB5 = 4;
    public static final int TAB6 = 5;
    public static final int TAB7 = 6;
    public static final int TAB8 = 7;
    public static final int TAB9 = 8;
    public static final int TAB10 = 9;
    public static final int TAB11 = 10;
    public static final int TAB12 = 11;
    public static final int TAB13 = 12;
    public static final int TAB14 = 13;
    public static final int TAB15 = 14;
    public static final int TAB16 = 15;
    public static final int TAB17 = 16;
    public static final int TAB18 = 17;
    public static final int TAB19 = 18;
    public static final int TAB20 = 19;
    private static final int MAX_NUM_TABS = 20;
    private static final String EXTRA_TAG_COUNT = FragNavController.class.getName() + ":EXTRA_TAG_COUNT";
    private static final String EXTRA_SELECTED_TAB_INDEX = FragNavController.class.getName() + ":EXTRA_SELECTED_TAB_INDEX";
    private static final String EXTRA_CURRENT_FRAGMENT = FragNavController.class.getName() + ":EXTRA_CURRENT_FRAGMENT";
    private static final String EXTRA_FRAGMENT_STACK = FragNavController.class.getName() + ":EXTRA_FRAGMENT_STACK";
    @IdRes
    private final int mContainerId;
    @NonNull
    private final List<Stack<Fragment>> mFragmentStacks;
    @NonNull
    private final FragmentManager mFragmentManager;
    private final FragNavTransactionOptions mDefaultTransactionOptions;
    private int mSelectedTabIndex;
    private int mTagCount;
    @Nullable
    private Fragment mCurrentFrag;
    @Nullable
    private DialogFragment mCurrentDialogFrag;
    @Nullable
    private RootFragmentListener mRootFragmentListener;
    @Nullable
    private TransactionListener mTransactionListener;
    private boolean mExecutingTransaction;

    private FragNavController(Builder builder, @Nullable Bundle savedInstanceState) {
        this.mFragmentManager = builder.mFragmentManager;
        this.mContainerId = builder.mContainerId;
        this.mFragmentStacks = new ArrayList<Stack<Fragment>>(builder.mNumberOfTabs);
        this.mRootFragmentListener = builder.mRootFragmentListener;
        this.mTransactionListener = builder.mTransactionListener;
        this.mDefaultTransactionOptions = builder.mDefaultTransactionOptions;
        this.mSelectedTabIndex = builder.mSelectedTabIndex;
        if (!this.restoreFromBundle(savedInstanceState, builder.mRootFragments)) {
            for (int i = 0; i < builder.mNumberOfTabs; ++i) {
                Stack stack = new Stack();
                if (builder.mRootFragments != null) {
                    stack.add(builder.mRootFragments.get(i));
                }
                this.mFragmentStacks.add(stack);
            }
            this.initialize(builder.mSelectedTabIndex);
        }
    }

    public static Builder newBuilder(@Nullable Bundle savedInstanceState, FragmentManager fragmentManager, int containerId) {
        return new Builder(savedInstanceState, fragmentManager, containerId);
    }

    public void switchTab(int index, @Nullable FragNavTransactionOptions transactionOptions) throws IndexOutOfBoundsException {
        if (index >= this.mFragmentStacks.size()) {
            throw new IndexOutOfBoundsException("Can't switch to a tab that hasn't been initialized, Index : " + index + ", current stack size : " + this.mFragmentStacks.size() + ". Make sure to create all of the tabs you need in the Constructor or provide a way for them to be created via RootFragmentListener.");
        }
        if (this.mSelectedTabIndex != index) {
            this.mSelectedTabIndex = index;
            FragmentTransaction ft = this.createTransactionWithOptions(transactionOptions, false);
            this.detachCurrentFragment(ft);
            Fragment fragment = null;
            if (index == -1) {
                this.commitTransaction(ft, transactionOptions);
            } else {
                fragment = this.reattachPreviousFragment(ft);
                if (fragment != null) {
                    this.commitTransaction(ft, transactionOptions);
                } else {
                    fragment = this.getRootFragment(this.mSelectedTabIndex);
                    ft.add(this.mContainerId, fragment, this.generateTag(fragment));
                    this.commitTransaction(ft, transactionOptions);
                }
            }
            this.mCurrentFrag = fragment;
            if (this.mTransactionListener != null) {
                this.mTransactionListener.onTabTransaction(this.mCurrentFrag, this.mSelectedTabIndex);
            }
        }
    }

    public void switchTab(int index) throws IndexOutOfBoundsException {
        this.switchTab(index, null);
    }

    public void pushFragment(@Nullable Fragment fragment, @Nullable FragNavTransactionOptions transactionOptions) {
        if (fragment != null && this.mSelectedTabIndex != -1) {
            FragmentTransaction ft = this.createTransactionWithOptions(transactionOptions, false);
            this.detachCurrentFragment(ft);
            ft.add(this.mContainerId, fragment, this.generateTag(fragment));
            this.commitTransaction(ft, transactionOptions);
            this.mFragmentStacks.get(this.mSelectedTabIndex).push(fragment);
            this.mCurrentFrag = fragment;
            if (this.mTransactionListener != null) {
                this.mTransactionListener.onFragmentTransaction(this.mCurrentFrag, TransactionType.PUSH);
            }
        }
    }

    public void pushFragment(@Nullable Fragment fragment) {
        this.pushFragment(fragment, null);
    }

    public void popFragment(@Nullable FragNavTransactionOptions transactionOptions) throws UnsupportedOperationException {
        this.popFragments(1, transactionOptions);
    }

    public void popFragment() throws UnsupportedOperationException {
        this.popFragment(null);
    }

    public void popFragments(int popDepth, @Nullable FragNavTransactionOptions transactionOptions) throws UnsupportedOperationException {
        Fragment fragment;
        if (this.isRootFragment()) {
            throw new UnsupportedOperationException("You can not popFragment the rootFragment. If you need to change this fragment, use replaceFragment(fragment)");
        }
        if (popDepth < 1) {
            throw new UnsupportedOperationException("popFragments parameter needs to be greater than 0");
        }
        if (this.mSelectedTabIndex == -1) {
            throw new UnsupportedOperationException("You can not pop fragments when no tab is selected");
        }
        if (popDepth >= this.mFragmentStacks.get(this.mSelectedTabIndex).size() - 1) {
            this.clearStack(transactionOptions);
            return;
        }
        FragmentTransaction ft = this.createTransactionWithOptions(transactionOptions, true);
        for (int i = 0; i < popDepth; ++i) {
            fragment = this.mFragmentManager.findFragmentByTag(this.mFragmentStacks.get(this.mSelectedTabIndex).pop().getTag());
            if (fragment == null) continue;
            ft.remove(fragment);
        }
        fragment = this.reattachPreviousFragment(ft);
        boolean bShouldPush = false;
        if (fragment != null) {
            this.commitTransaction(ft, transactionOptions);
        } else if (!this.mFragmentStacks.get(this.mSelectedTabIndex).isEmpty()) {
            fragment = this.mFragmentStacks.get(this.mSelectedTabIndex).peek();
            ft.add(this.mContainerId, fragment, fragment.getTag());
            this.commitTransaction(ft, transactionOptions);
        } else {
            fragment = this.getRootFragment(this.mSelectedTabIndex);
            ft.add(this.mContainerId, fragment, this.generateTag(fragment));
            this.commitTransaction(ft, transactionOptions);
            bShouldPush = true;
        }
        if (bShouldPush) {
            this.mFragmentStacks.get(this.mSelectedTabIndex).push(fragment);
        }
        this.mCurrentFrag = fragment;
        if (this.mTransactionListener != null) {
            this.mTransactionListener.onFragmentTransaction(this.mCurrentFrag, TransactionType.POP);
        }
    }

    public void popFragments(int popDepth) throws UnsupportedOperationException {
        this.popFragments(popDepth, null);
    }

    public void clearStack(@Nullable FragNavTransactionOptions transactionOptions) {
        if (this.mSelectedTabIndex == -1) {
            return;
        }
        Stack<Fragment> fragmentStack = this.mFragmentStacks.get(this.mSelectedTabIndex);
        if (fragmentStack.size() > 1) {
            Fragment fragment;
            FragmentTransaction ft = this.createTransactionWithOptions(transactionOptions, true);
            while (fragmentStack.size() > 1) {
                fragment = this.mFragmentManager.findFragmentByTag(fragmentStack.pop().getTag());
                if (fragment == null) continue;
                ft.remove(fragment);
            }
            fragment = this.reattachPreviousFragment(ft);
            boolean bShouldPush = false;
            if (fragment != null) {
                this.commitTransaction(ft, transactionOptions);
            } else if (!fragmentStack.isEmpty()) {
                fragment = fragmentStack.peek();
                ft.add(this.mContainerId, fragment, fragment.getTag());
                this.commitTransaction(ft, transactionOptions);
            } else {
                fragment = this.getRootFragment(this.mSelectedTabIndex);
                ft.add(this.mContainerId, fragment, this.generateTag(fragment));
                this.commitTransaction(ft, transactionOptions);
                bShouldPush = true;
            }
            if (bShouldPush) {
                this.mFragmentStacks.get(this.mSelectedTabIndex).push(fragment);
            }
            this.mFragmentStacks.set(this.mSelectedTabIndex, fragmentStack);
            this.mCurrentFrag = fragment;
            if (this.mTransactionListener != null) {
                this.mTransactionListener.onFragmentTransaction(this.mCurrentFrag, TransactionType.POP);
            }
        }
    }

    public void clearStack() {
        this.clearStack(null);
    }

    public void replaceFragment(@NonNull Fragment fragment, @Nullable FragNavTransactionOptions transactionOptions) {
        Fragment poppingFrag = this.getCurrentFrag();
        if (poppingFrag != null) {
            FragmentTransaction ft = this.createTransactionWithOptions(transactionOptions, false);
            Stack<Fragment> fragmentStack = this.mFragmentStacks.get(this.mSelectedTabIndex);
            if (!fragmentStack.isEmpty()) {
                fragmentStack.pop();
            }
            String tag = this.generateTag(fragment);
            ft.replace(this.mContainerId, fragment, tag);
            this.commitTransaction(ft, transactionOptions);
            fragmentStack.push(fragment);
            this.mCurrentFrag = fragment;
            if (this.mTransactionListener != null) {
                this.mTransactionListener.onFragmentTransaction(this.mCurrentFrag, TransactionType.REPLACE);
            }
        }
    }

    public void replaceFragment(@NonNull Fragment fragment) {
        this.replaceFragment(fragment, null);
    }

    @Nullable
    @CheckResult
    public DialogFragment getCurrentDialogFrag() {
        if (this.mCurrentDialogFrag != null) {
            return this.mCurrentDialogFrag;
        }
        FragmentManager fragmentManager = this.mCurrentFrag != null ? this.mCurrentFrag.getChildFragmentManager() : this.mFragmentManager;
        if (fragmentManager.getFragments() != null) {
            for (Fragment fragment : fragmentManager.getFragments()) {
                if (!(fragment instanceof DialogFragment)) continue;
                this.mCurrentDialogFrag = (DialogFragment)fragment;
                break;
            }
        }
        return this.mCurrentDialogFrag;
    }

    public void clearDialogFragment() {
        if (this.mCurrentDialogFrag != null) {
            this.mCurrentDialogFrag.dismiss();
            this.mCurrentDialogFrag = null;
        } else {
            FragmentManager fragmentManager = this.mCurrentFrag != null ? this.mCurrentFrag.getChildFragmentManager() : this.mFragmentManager;
            if (fragmentManager.getFragments() != null) {
                for (Fragment fragment : fragmentManager.getFragments()) {
                    if (!(fragment instanceof DialogFragment)) continue;
                    ((DialogFragment)fragment).dismiss();
                }
            }
        }
    }

    public void showDialogFragment(@Nullable DialogFragment dialogFragment) {
        if (dialogFragment != null) {
            FragmentManager fragmentManager = this.mCurrentFrag != null ? this.mCurrentFrag.getChildFragmentManager() : this.mFragmentManager;
            if (fragmentManager.getFragments() != null) {
                for (Fragment fragment : fragmentManager.getFragments()) {
                    if (!(fragment instanceof DialogFragment)) continue;
                    ((DialogFragment)fragment).dismiss();
                    this.mCurrentDialogFrag = null;
                }
            }
            this.mCurrentDialogFrag = dialogFragment;
            try {
                dialogFragment.show(fragmentManager, dialogFragment.getClass().getName());
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private void initialize(int index) {
        this.mSelectedTabIndex = index;
        if (this.mSelectedTabIndex > this.mFragmentStacks.size()) {
            throw new IndexOutOfBoundsException("Starting index cannot be larger than the number of stacks");
        }
        this.mSelectedTabIndex = index;
        this.clearFragmentManager();
        this.clearDialogFragment();
        if (index == -1) {
            return;
        }
        FragmentTransaction ft = this.createTransactionWithOptions(null, false);
        Fragment fragment = this.getRootFragment(index);
        ft.add(this.mContainerId, fragment, this.generateTag(fragment));
        this.commitTransaction(ft, null);
        this.mCurrentFrag = fragment;
        if (this.mTransactionListener != null) {
            this.mTransactionListener.onTabTransaction(this.mCurrentFrag, this.mSelectedTabIndex);
        }
    }

    @NonNull
    @CheckResult
    private Fragment getRootFragment(int index) throws IllegalStateException {
        Fragment fragment = null;
        if (!this.mFragmentStacks.get(index).isEmpty()) {
            fragment = this.mFragmentStacks.get(index).peek();
        } else if (this.mRootFragmentListener != null) {
            fragment = this.mRootFragmentListener.getRootFragment(index);
            if (this.mSelectedTabIndex != -1) {
                this.mFragmentStacks.get(this.mSelectedTabIndex).push(fragment);
            }
        }
        if (fragment == null) {
            throw new IllegalStateException("Either you haven't past in a fragment at this index in your constructor, or you haven't provided a way to create it while via your RootFragmentListener.getRootFragment(index)");
        }
        return fragment;
    }

    @Nullable
    private Fragment reattachPreviousFragment(@NonNull FragmentTransaction ft) {
        Stack<Fragment> fragmentStack = this.mFragmentStacks.get(this.mSelectedTabIndex);
        Fragment fragment = null;
        if (!fragmentStack.isEmpty() && (fragment = this.mFragmentManager.findFragmentByTag(fragmentStack.peek().getTag())) != null) {
            ft.attach(fragment);
        }
        return fragment;
    }

    private void detachCurrentFragment(@NonNull FragmentTransaction ft) {
        Fragment oldFrag = this.getCurrentFrag();
        if (oldFrag != null) {
            ft.detach(oldFrag);
        }
    }

    @Nullable
    @CheckResult
    public Fragment getCurrentFrag() {
        if (this.mCurrentFrag != null) {
            return this.mCurrentFrag;
        }
        if (this.mSelectedTabIndex == -1) {
            return null;
        }
        Stack<Fragment> fragmentStack = this.mFragmentStacks.get(this.mSelectedTabIndex);
        if (!fragmentStack.isEmpty()) {
            this.mCurrentFrag = this.mFragmentManager.findFragmentByTag(this.mFragmentStacks.get(this.mSelectedTabIndex).peek().getTag());
        }
        return this.mCurrentFrag;
    }

    @NonNull
    @CheckResult
    private String generateTag(@NonNull Fragment fragment) {
        return fragment.getClass().getName() + ++this.mTagCount;
    }

    private void executePendingTransactions() {
        if (!this.mExecutingTransaction) {
            this.mExecutingTransaction = true;
            this.mFragmentManager.executePendingTransactions();
            this.mExecutingTransaction = false;
        }
    }

    private void clearFragmentManager() {
        if (this.mFragmentManager.getFragments() != null) {
            FragmentTransaction ft = this.createTransactionWithOptions(null, false);
            for (Fragment fragment : this.mFragmentManager.getFragments()) {
                if (fragment == null) continue;
                ft.remove(fragment);
            }
            this.commitTransaction(ft, null);
        }
    }

    @CheckResult
    private FragmentTransaction createTransactionWithOptions(@Nullable FragNavTransactionOptions transactionOptions, boolean isPopping) {
        FragmentTransaction ft = this.mFragmentManager.beginTransaction();
        if (transactionOptions == null) {
            transactionOptions = this.mDefaultTransactionOptions;
        }
        if (transactionOptions != null) {
            if (isPopping) {
                ft.setCustomAnimations(transactionOptions.popEnterAnimation, transactionOptions.popExitAnimation);
            } else {
                ft.setCustomAnimations(transactionOptions.enterAnimation, transactionOptions.exitAnimation);
            }
            ft.setTransitionStyle(transactionOptions.transitionStyle);
            ft.setTransition(transactionOptions.transition);
            if (transactionOptions.sharedElements != null) {
                for (Pair<View, String> sharedElement : transactionOptions.sharedElements) {
                    ft.addSharedElement((View)sharedElement.first, (String)sharedElement.second);
                }
            }
            if (transactionOptions.breadCrumbTitle != null) {
                ft.setBreadCrumbTitle((CharSequence)transactionOptions.breadCrumbTitle);
            }
            if (transactionOptions.breadCrumbShortTitle != null) {
                ft.setBreadCrumbShortTitle((CharSequence)transactionOptions.breadCrumbShortTitle);
            }
        }
        return ft;
    }

    private void commitTransaction(FragmentTransaction fragmentTransaction, @Nullable FragNavTransactionOptions transactionOptions) {
        if (transactionOptions != null && transactionOptions.allowStateLoss) {
            fragmentTransaction.commitAllowingStateLoss();
        } else {
            fragmentTransaction.commit();
        }
        this.executePendingTransactions();
    }

    @CheckResult
    public int getSize() {
        return this.mFragmentStacks.size();
    }

    @CheckResult
    @Nullable
    public Stack<Fragment> getStack(int index) {
        if (index == -1) {
            return null;
        }
        if (index >= this.mFragmentStacks.size()) {
            throw new IndexOutOfBoundsException("Can't get an index that's larger than we've setup");
        }
        return (Stack)this.mFragmentStacks.get(index).clone();
    }

    @CheckResult
    @Nullable
    public Stack<Fragment> getCurrentStack() {
        return this.getStack(this.mSelectedTabIndex);
    }

    @CheckResult
    public int getCurrentStackIndex() {
        return this.mSelectedTabIndex;
    }

    @CheckResult
    public boolean isRootFragment() {
        Stack<Fragment> stack = this.getCurrentStack();
        return stack == null || stack.size() == 1;
    }

    public boolean isStateSaved() {
        return this.mFragmentManager.isStateSaved();
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        outState.putInt(EXTRA_TAG_COUNT, this.mTagCount);
        outState.putInt(EXTRA_SELECTED_TAB_INDEX, this.mSelectedTabIndex);
        if (this.mCurrentFrag != null) {
            outState.putString(EXTRA_CURRENT_FRAGMENT, this.mCurrentFrag.getTag());
        }
        try {
            JSONArray stackArrays = new JSONArray();
            for (Stack<Fragment> stack : this.mFragmentStacks) {
                JSONArray stackArray = new JSONArray();
                for (Fragment fragment : stack) {
                    stackArray.put((Object)fragment.getTag());
                }
                stackArrays.put((Object)stackArray);
            }
            outState.putString(EXTRA_FRAGMENT_STACK, stackArrays.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean restoreFromBundle(@Nullable Bundle savedInstanceState, @Nullable List<Fragment> rootFragments) {
        if (savedInstanceState == null) {
            return false;
        }
        this.mTagCount = savedInstanceState.getInt(EXTRA_TAG_COUNT, 0);
        this.mCurrentFrag = this.mFragmentManager.findFragmentByTag(savedInstanceState.getString(EXTRA_CURRENT_FRAGMENT));
        try {
            JSONArray stackArrays = new JSONArray(savedInstanceState.getString(EXTRA_FRAGMENT_STACK));
            for (int x = 0; x < stackArrays.length(); ++x) {
                JSONArray stackArray = stackArrays.getJSONArray(x);
                Stack<Fragment> stack = new Stack<Fragment>();
                if (stackArray.length() == 1) {
                    String tag = stackArray.getString(0);
                    Fragment fragment = tag == null || "null".equalsIgnoreCase(tag) ? (rootFragments != null ? rootFragments.get(x) : this.getRootFragment(x)) : this.mFragmentManager.findFragmentByTag(tag);
                    if (fragment != null) {
                        stack.add(fragment);
                    }
                } else {
                    for (int y = 0; y < stackArray.length(); ++y) {
                        Fragment fragment;
                        String tag = stackArray.getString(y);
                        if (tag == null || "null".equalsIgnoreCase(tag) || (fragment = this.mFragmentManager.findFragmentByTag(tag)) == null) continue;
                        stack.add(fragment);
                    }
                }
                this.mFragmentStacks.add(stack);
            }
            int selectedTabIndex = savedInstanceState.getInt(EXTRA_SELECTED_TAB_INDEX);
            if (selectedTabIndex >= 0 && selectedTabIndex < 20) {
                this.switchTab(selectedTabIndex);
            }
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static final class Builder {
        private final int mContainerId;
        private FragmentManager mFragmentManager;
        private RootFragmentListener mRootFragmentListener;
        private int mSelectedTabIndex = 0;
        private TransactionListener mTransactionListener;
        private FragNavTransactionOptions mDefaultTransactionOptions;
        private int mNumberOfTabs = 0;
        private List<Fragment> mRootFragments;
        private Bundle mSavedInstanceState;

        public Builder(@Nullable Bundle savedInstanceState, FragmentManager mFragmentManager, int mContainerId) {
            this.mSavedInstanceState = savedInstanceState;
            this.mFragmentManager = mFragmentManager;
            this.mContainerId = mContainerId;
        }

        public Builder selectedTabIndex(int selectedTabIndex) {
            this.mSelectedTabIndex = selectedTabIndex;
            if (this.mRootFragments != null && this.mSelectedTabIndex > this.mNumberOfTabs) {
                throw new IndexOutOfBoundsException("Starting index cannot be larger than the number of stacks");
            }
            return this;
        }

        public Builder rootFragment(Fragment rootFragment) {
            this.mRootFragments = new ArrayList<Fragment>(1);
            this.mRootFragments.add(rootFragment);
            this.mNumberOfTabs = 1;
            return this.rootFragments(this.mRootFragments);
        }

        public Builder rootFragments(@NonNull List<Fragment> rootFragments) {
            this.mRootFragments = rootFragments;
            this.mNumberOfTabs = rootFragments.size();
            if (this.mNumberOfTabs > 20) {
                throw new IllegalArgumentException("Number of root fragments cannot be greater than 20");
            }
            return this;
        }

        public Builder defaultTransactionOptions(@NonNull FragNavTransactionOptions transactionOptions) {
            this.mDefaultTransactionOptions = transactionOptions;
            return this;
        }

        public Builder rootFragmentListener(RootFragmentListener rootFragmentListener, int numberOfTabs) {
            this.mRootFragmentListener = rootFragmentListener;
            this.mNumberOfTabs = numberOfTabs;
            if (this.mNumberOfTabs > 20) {
                throw new IllegalArgumentException("Number of tabs cannot be greater than 20");
            }
            return this;
        }

        public Builder transactionListener(TransactionListener val) {
            this.mTransactionListener = val;
            return this;
        }

        public FragNavController build() {
            if (this.mRootFragmentListener == null && this.mRootFragments == null) {
                throw new IndexOutOfBoundsException("Either a root fragment(s) needs to be set, or a fragment listener");
            }
            return new FragNavController(this, this.mSavedInstanceState);
        }
    }

    public static interface TransactionListener {
        public void onTabTransaction(Fragment var1, int var2);

        public void onFragmentTransaction(Fragment var1, TransactionType var2);
    }

    public static interface RootFragmentListener {
        public Fragment getRootFragment(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TabIndex {
    }

    public static enum TransactionType {
        PUSH,
        POP,
        REPLACE;

    }
}

