/*
 * Decompiled with CFR 0.152.
 */
package com.ncapdevi.fragnav;

import android.support.annotation.AnimRes;
import android.support.annotation.StyleRes;
import android.support.v4.util.Pair;
import android.view.View;
import java.util.ArrayList;
import java.util.List;

public class FragNavTransactionOptions {
    List<Pair<View, String>> sharedElements;
    int transition = 0;
    @AnimRes
    int enterAnimation = 0;
    @AnimRes
    int exitAnimation = 0;
    @AnimRes
    int popEnterAnimation = 0;
    @AnimRes
    int popExitAnimation = 0;
    @StyleRes
    int transitionStyle = 0;
    String breadCrumbTitle;
    String breadCrumbShortTitle;

    private FragNavTransactionOptions(Builder builder) {
        this.sharedElements = builder.sharedElements;
        this.transition = builder.transition;
        this.enterAnimation = builder.enterAnimation;
        this.exitAnimation = builder.exitAnimation;
        this.transitionStyle = builder.transitionStyle;
        this.popEnterAnimation = builder.popEnterAnimation;
        this.popExitAnimation = builder.popExitAnimation;
        this.breadCrumbTitle = builder.breadCrumbTitle;
        this.breadCrumbShortTitle = builder.breadCrumbShortTitle;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Pair<View, String>> sharedElements;
        private int transition;
        private int enterAnimation;
        private int exitAnimation;
        private int transitionStyle;
        private int popEnterAnimation;
        private int popExitAnimation;
        private String breadCrumbTitle;
        private String breadCrumbShortTitle;

        private Builder() {
        }

        public Builder addSharedElement(Pair<View, String> val) {
            if (this.sharedElements == null) {
                this.sharedElements = new ArrayList<Pair<View, String>>(3);
            }
            this.sharedElements.add(val);
            return this;
        }

        public Builder sharedElements(List<Pair<View, String>> val) {
            this.sharedElements = val;
            return this;
        }

        public Builder transition(int val) {
            this.transition = val;
            return this;
        }

        public Builder customAnimations(@AnimRes int enterAnimation, @AnimRes int exitAnimation) {
            this.enterAnimation = enterAnimation;
            this.exitAnimation = exitAnimation;
            return this;
        }

        public Builder customAnimations(@AnimRes int enterAnimation, @AnimRes int exitAnimation, @AnimRes int popEnterAnimation, @AnimRes int popExitAnimation) {
            this.popEnterAnimation = popEnterAnimation;
            this.popExitAnimation = popExitAnimation;
            return this.customAnimations(enterAnimation, exitAnimation);
        }

        public Builder transitionStyle(@StyleRes int val) {
            this.transitionStyle = val;
            return this;
        }

        public Builder breadCrumbTitle(String val) {
            this.breadCrumbTitle = val;
            return this;
        }

        public Builder breadCrumbShortTitle(String val) {
            this.breadCrumbShortTitle = val;
            return this;
        }

        public FragNavTransactionOptions build() {
            return new FragNavTransactionOptions(this);
        }
    }
}

