/*
 * Decompiled with CFR 0.152.
 */
package com.nbsaas.codemake.fields;

import com.nbsaas.codemake.annotation.FieldConvert;
import com.nbsaas.codemake.annotation.FieldName;
import com.nbsaas.codemake.annotation.FormAnnotation;
import com.nbsaas.codemake.annotation.FormField;
import com.nbsaas.codemake.annotation.NoHandle;
import com.nbsaas.codemake.annotation.NoResponse;
import com.nbsaas.codemake.annotation.NoSimple;
import com.nbsaas.codemake.annotation.SearchBean;
import com.nbsaas.codemake.annotation.SearchItem;
import com.nbsaas.codemake.fields.DaoBean;
import com.nbsaas.codemake.fields.EnumBean;
import com.nbsaas.codemake.fields.FieldBean;
import com.nbsaas.codemake.fields.FormBean;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class FormBeanConvert {
    public List<FieldBean> search(Class<?> object) {
        SearchItem[] items;
        ArrayList<FieldBean> beans = new ArrayList<FieldBean>();
        for (Class<?> clazz = object; clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fs = clazz.getDeclaredFields();
            for (Field f : fs) {
                f.setAccessible(true);
                SearchItem annotation = f.getAnnotation(SearchItem.class);
                if (annotation == null) continue;
                FieldBean bean = new FieldBean();
                if (annotation == null) continue;
                bean.setType(annotation.type().name());
                bean.setPlaceholder(annotation.placeholder());
                bean.setTitle(annotation.label());
                bean.setId(annotation.name());
                bean.setClassName(annotation.classType());
                bean.setKey(annotation.key());
                bean.setOperator(annotation.operator());
                Integer sortNum = this.getInteger(annotation);
                bean.setSortNum(sortNum);
                bean.setShow(annotation.show());
                if (StringUtils.isEmpty((CharSequence)bean.getTitle())) {
                    bean.setTitle(f.getName());
                }
                if (StringUtils.isEmpty((CharSequence)bean.getKey())) {
                    bean.setKey(f.getName());
                }
                if (StringUtils.isEmpty((CharSequence)bean.getId())) {
                    bean.setId(f.getName());
                }
                if (StringUtils.isEmpty((CharSequence)bean.getPlaceholder())) {
                    bean.setPlaceholder(bean.getTitle());
                }
                beans.add(bean);
            }
        }
        SearchBean bean = object.getAnnotation(SearchBean.class);
        if (bean != null && (items = bean.items()) != null) {
            for (SearchItem item : items) {
                FieldBean fieldBean = new FieldBean();
                if (item == null) continue;
                fieldBean.setType(item.type().name());
                fieldBean.setPlaceholder(item.placeholder());
                fieldBean.setTitle(item.label());
                fieldBean.setId(item.name());
                fieldBean.setClassName(item.classType());
                fieldBean.setKey(item.key());
                fieldBean.setOperator(item.operator());
                fieldBean.setShow(item.show());
                Integer sortNum = this.getInteger(item);
                fieldBean.setSortNum(sortNum);
                if (StringUtils.isEmpty((CharSequence)fieldBean.getKey())) {
                    fieldBean.setKey(fieldBean.getId());
                }
                if (StringUtils.isEmpty((CharSequence)fieldBean.getPlaceholder())) {
                    fieldBean.setPlaceholder("");
                }
                beans.add(fieldBean);
            }
        }
        beans.sort(new Comparator<FieldBean>(){

            @Override
            public int compare(FieldBean o1, FieldBean o2) {
                return o1.getSortNum().compareTo(o2.getSortNum());
            }
        });
        return beans;
    }

    public boolean haveId(Field field) {
        Annotation[] as = field.getAnnotations();
        if (as != null && as.length > 0) {
            for (Annotation a : as) {
                if (!"Id".equals(a.annotationType().getSimpleName())) continue;
                return true;
            }
        }
        return false;
    }

    public Set<FieldBean> fields(Class<?> object) {
        HashSet<FieldBean> beans = new HashSet<FieldBean>();
        for (Class<?> clazz = object; clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fs;
            for (Field f : fs = clazz.getDeclaredFields()) {
                FieldBean bean;
                NoHandle noHandle;
                f.setAccessible(true);
                if (this.haveId(f) || (noHandle = f.getAnnotation(NoHandle.class)) != null) continue;
                FieldConvert convert = f.getAnnotation(FieldConvert.class);
                if (convert != null) {
                    bean = new FieldBean();
                    bean.setId(f.getName());
                    bean.setType(convert.classType());
                    bean.setFieldType(2);
                    beans.add(bean);
                }
                if (f.getType().isEnum()) {
                    bean = new FieldBean();
                    bean.setId(f.getName());
                    bean.setType(f.getType().getSimpleName());
                    bean.setFieldType(4);
                    beans.add(bean);
                    continue;
                }
                if (!f.getType().getName().startsWith("java.lang") && !f.getType().getName().equals("int") && !f.getType().getName().equals("long") && !f.getType().getName().equals("float") && !f.getType().getName().equals("double") && !f.getType().getName().equals("Date") && !f.getType().getSimpleName().equals("BigDecimal") && !f.getType().getSimpleName().equals("Date")) continue;
                bean = new FieldBean();
                bean.setId(f.getName());
                bean.setType(f.getType().getSimpleName());
                bean.setFieldType(1);
                beans.add(bean);
            }
        }
        return beans;
    }

    public Set<FieldBean> fieldsForSimple(Class<?> object) {
        return this.getFieldBeans(object, NoSimple.class);
    }

    public Set<FieldBean> fieldsForResponse(Class<?> object) {
        return this.getFieldBeans(object, NoResponse.class);
    }

    private Set<FieldBean> getFieldBeans(Class<?> object, Class annotation) {
        HashSet<FieldBean> beans = new HashSet<FieldBean>();
        for (Class<?> clazz = object; clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fs;
            for (Field f : fs = clazz.getDeclaredFields()) {
                FieldBean bean;
                FieldName fieldName;
                f.setAccessible(true);
                if (this.haveId(f)) continue;
                FieldConvert convert = f.getAnnotation(FieldConvert.class);
                if (convert != null) {
                    FieldBean bean2 = new FieldBean();
                    bean2.setId(f.getName());
                    bean2.setType(convert.classType());
                    bean2.setFieldType(2);
                    beans.add(bean2);
                }
                if ((fieldName = f.getAnnotation(FieldName.class)) != null) {
                    bean = new FieldBean();
                    String parentName = fieldName.name();
                    if (StringUtil.isNotBlank((CharSequence)parentName)) {
                        bean.setId(parentName);
                        String parent = fieldName.parent();
                        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{parent})) {
                            bean.setExtName(parent);
                        } else {
                            bean.setExtName(parentName);
                        }
                    } else {
                        bean.setId(f.getName() + "Name");
                        bean.setExtName("Name");
                    }
                    bean.setParent(f.getName());
                    bean.setType(fieldName.classType());
                    bean.setFieldType(3);
                    beans.add(bean);
                }
                if (f.getType().isEnum()) {
                    bean = new FieldBean();
                    bean.setId(f.getName());
                    bean.setType(f.getType().getSimpleName());
                    bean.setFieldType(4);
                    beans.add(bean);
                }
                if (!f.getType().getName().startsWith("java.lang") && !f.getType().getName().equals("int") && !f.getType().getName().equals("long") && !f.getType().getName().equals("float") && !f.getType().getName().equals("double") && !f.getType().getSimpleName().equals("BigDecimal") && !f.getType().getSimpleName().equals("Date") || f.getAnnotation(annotation) != null) continue;
                bean = new FieldBean();
                bean.setId(f.getName());
                bean.setType(f.getType().getSimpleName());
                bean.setFieldType(1);
                beans.add(bean);
            }
        }
        return beans;
    }

    public FormBean convertClass(Class<?> object) {
        FormBean formBean = new FormBean();
        List<FieldBean> beanList = formBean.getFields();
        FormAnnotation formAnnotation = object.getAnnotation(FormAnnotation.class);
        if (formAnnotation != null) {
            formBean.setTitle(formAnnotation.title());
            formBean.setMenu(formAnnotation.menu());
            formBean.setViewWidth(formAnnotation.viewWidth());
            formBean.setSearchWidth(formAnnotation.searchWidth());
        }
        for (Class<?> clazz = object; clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fs;
            for (Field f : fs = clazz.getDeclaredFields()) {
                f.setAccessible(true);
                if (this.haveId(f)) continue;
                FormField field = f.getAnnotation(FormField.class);
                FieldBean bean = new FieldBean();
                if (field == null) continue;
                if (f.getType().isEnum()) {
                    bean.setFieldType(4);
                    bean.setExtName("Name");
                } else {
                    bean.setFieldType(1);
                    bean.setExtName("");
                }
                FieldName fieldName = f.getAnnotation(FieldName.class);
                if (fieldName != null) {
                    bean.setFieldType(3);
                    bean.setExtName("Name");
                }
                bean.setWidth(field.width());
                bean.setClassName(field.className());
                bean.setId(field.id());
                if (bean.getId() == null) {
                    bean.setId(f.getName());
                }
                bean.setType(field.type().name());
                bean.setPlaceholder(field.placeholder());
                Integer sortNum = this.getInteger(field);
                bean.setSortNum(sortNum);
                bean.setTitle(field.title());
                bean.setCol(field.col());
                bean.setRequired(field.required());
                bean.setOption(field.option());
                bean.setSort(field.sort());
                if (field.grid()) {
                    formBean.getGrids().add(bean);
                }
                if (StringUtils.isEmpty((CharSequence)bean.getTitle())) {
                    bean.setTitle(f.getName());
                }
                if (StringUtils.isEmpty((CharSequence)bean.getId())) {
                    bean.setId(f.getName());
                }
                if (StringUtils.isEmpty((CharSequence)bean.getPlaceholder())) {
                    bean.setPlaceholder(bean.getTitle());
                }
                if ("date".equals(bean.getType())) {
                    formBean.setHasDate(true);
                    formBean.getDates().add(bean);
                }
                if ("image".equals(bean.getType())) {
                    formBean.setHasImage(true);
                    formBean.getImages().add(bean);
                }
                if (field.ignore() || beanList.contains(bean)) continue;
                beanList.add(bean);
            }
        }
        beanList.sort(new Comparator<FieldBean>(){

            @Override
            public int compare(FieldBean o1, FieldBean o2) {
                return o1.getSortNum().compareTo(o2.getSortNum());
            }
        });
        Collections.sort(formBean.getGrids());
        return formBean;
    }

    public FormBean conver(Object object) {
        return this.convertClass(object.getClass());
    }

    private Integer getInteger(FormField annotation) {
        Integer result = 0;
        String b = annotation.sortNum();
        try {
            result = Integer.parseInt(b);
        }
        catch (Exception e) {
            result = 0;
        }
        return result;
    }

    private Integer getInteger(SearchItem annotation) {
        Integer result = 0;
        String b = annotation.sortNum();
        try {
            result = Integer.parseInt(b);
        }
        catch (Exception e) {
            result = 0;
        }
        return result;
    }

    public Set<DaoBean> daoBeans(Class<?> object) {
        HashSet<DaoBean> beans = new HashSet<DaoBean>();
        for (Class<?> clazz = object; clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fs;
            for (Field field : fs = clazz.getDeclaredFields()) {
                FieldConvert convert;
                field.setAccessible(true);
                if (this.haveId(field) || (convert = field.getAnnotation(FieldConvert.class)) == null) continue;
                DaoBean bean = new DaoBean();
                String dao = field.getType().getCanonicalName();
                dao = dao.replace("entity", "dao") + "Dao";
                bean.setDaoName(dao);
                bean.setDao(field.getType().getSimpleName() + "Dao");
                bean.setDaoField(field.getName());
                beans.add(bean);
            }
        }
        return beans;
    }

    public Set<EnumBean> enums(Class<?> object) {
        HashSet<EnumBean> beans = new HashSet<EnumBean>();
        for (Class<?> clazz = object; clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fs;
            for (Field f : fs = clazz.getDeclaredFields()) {
                f.setAccessible(true);
                if (!f.getType().isEnum()) continue;
                EnumBean bean = new EnumBean();
                String dao = f.getType().getCanonicalName();
                bean.setClassName(f.getType().getName());
                bean.setField(f.getName());
                beans.add(bean);
            }
        }
        return beans;
    }
}

