/*
 * Decompiled with CFR 0.152.
 */
package com.nbsaas.codemake.commands.vue;

import com.nbsaas.codemake.commands.base.CodeBaseCommand;
import com.nbsaas.codemake.templates.vue.VueDir;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import org.apache.commons.chain.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VueCommand
extends CodeBaseCommand {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean execute(Context context) throws Exception {
        Class entity;
        File dir;
        boolean isView = (Boolean)context.get("isView");
        if (!isView) {
            return false;
        }
        this.logger.info("vue\u9875\u9762\u751f\u6210");
        Class classDir = (Class)context.get("dir");
        ClassTemplateLoader ctl = new ClassTemplateLoader(classDir, "/" + classDir.getName().replace(classDir.getSimpleName(), "").replace(".", "/"));
        Configuration config = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        config.setTemplateLoader((TemplateLoader)ctl);
        File view = (File)context.get("view");
        if (!view.exists()) {
            view.mkdirs();
        }
        if (!(dir = new File(view, (entity = (Class)context.get("entity")).getSimpleName().toLowerCase())).exists()) {
            dir.mkdirs();
        }
        if (classDir.equals(VueDir.class)) {
            Boolean catalog = (Boolean)context.get("catalog");
            if (catalog.booleanValue()) {
                this.handle(dir, config, context, "tree.ftl", "index.vue");
            } else {
                if (this.getBoolean(context, "componentAdd", true).booleanValue()) {
                    this.handle(dir, config, context, "add.ftl", "add.vue");
                }
                if (this.getBoolean(context, "componentList", true).booleanValue()) {
                    this.handle(dir, config, context, "index.ftl", "index.vue");
                }
                if (this.getBoolean(context, "componentUpdate", true).booleanValue()) {
                    this.handle(dir, config, context, "update.ftl", "update.vue");
                }
            }
            Boolean childView = this.getBoolean(context, "childView", false);
            String name = this.getString(context, "config_entity", "router");
            if (childView.booleanValue()) {
                this.handle(dir, config, context, "view_layout.ftl", "view_layout.vue");
                this.handle(dir, config, context, "router2.ftl", name + ".js");
                if (this.getBoolean(context, "componentShow", true).booleanValue()) {
                    this.handle(dir, config, context, "view_simple.ftl", "view.vue");
                }
            } else {
                this.handle(dir, config, context, "router.ftl", name + ".js");
                if (this.getBoolean(context, "componentShow", true).booleanValue()) {
                    this.handle(dir, config, context, "view.ftl", "view.vue");
                }
            }
        }
        return false;
    }

    private void handle(File dir, Configuration config, Context context, String template, String out) {
        try {
            FileWriter component = new FileWriter(new File(dir, out));
            config.getTemplate(template).process((Object)context, (Writer)component);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

