/*
 * Decompiled with CFR 0.152.
 */
package com.natradac.android.tokeninterceptor;

import android.content.Context;
import android.content.SharedPreferences;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.natradac.android.tokeninterceptor.CannotMapResponseToObject;
import com.natradac.android.tokeninterceptor.NotFoundTokenException;
import com.natradac.android.tokeninterceptor.RefreshToken;
import com.natradac.android.tokeninterceptor.RefreshTokenException;
import com.natradac.android.tokeninterceptor.RefreshTokenExpired;
import com.natradac.android.tokeninterceptor.db.PreferenceHelper;
import java.io.IOException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u000b\u001a\u00020\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/natradac/android/tokeninterceptor/ExpiredTokenInterceptor;", "Lokhttp3/Interceptor;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "refreshToken", "", "updateToken", "data", "", "", "Ljava/lang/Object;", "TokenInterceptor_release"})
public final class ExpiredTokenInterceptor
implements Interceptor {
    private final Context context;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request request = chain.request();
        SharedPreferences pref = PreferenceHelper.INSTANCE.defaultPrefs(this.context);
        try {
            String token = pref.getString("TOKEN", null);
            if (token == null) {
                throw (Throwable)new NotFoundTokenException();
            }
            if (PreferenceHelper.INSTANCE.isAccessTokenExpired(this.context)) {
                String string;
                void defaultValue$iv;
                void key$iv;
                void $this$get$iv;
                if (PreferenceHelper.INSTANCE.isRefreshTokenExpired(this.context)) {
                    throw (Throwable)new RefreshTokenExpired();
                }
                this.refreshToken(chain);
                SharedPreferences sharedPreferences = pref;
                PreferenceHelper preferenceHelper = PreferenceHelper.INSTANCE;
                String string2 = "TOKEN";
                String string3 = "";
                String string4 = "Authorization";
                Request.Builder builder = request.newBuilder();
                boolean $i$f$get = false;
                KClass kClass = Reflection.getOrCreateKotlinClass(String.class);
                if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    string = $this$get$iv.getString((String)key$iv, (String)defaultValue$iv);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    Object v1 = defaultValue$iv;
                    if (!(v1 instanceof Integer)) {
                        v1 = null;
                    }
                    Integer n = v1;
                    string = (String)((Object)Integer.valueOf($this$get$iv.getInt((String)key$iv, n != null ? n : -1)));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    Object v3 = defaultValue$iv;
                    if (!(v3 instanceof Boolean)) {
                        v3 = null;
                    }
                    Boolean bl = v3;
                    string = (String)((Object)Boolean.valueOf($this$get$iv.getBoolean((String)key$iv, bl != null ? bl : false)));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                    Object v5 = defaultValue$iv;
                    if (!(v5 instanceof Float)) {
                        v5 = null;
                    }
                    Float f = v5;
                    string = (String)((Object)Float.valueOf($this$get$iv.getFloat((String)key$iv, f != null ? f.floatValue() : -1.0f)));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    Object v7 = defaultValue$iv;
                    if (!(v7 instanceof Long)) {
                        v7 = null;
                    }
                    Long l = v7;
                    string = (String)((Object)Long.valueOf($this$get$iv.getLong((String)key$iv, l != null ? l : -1L)));
                } else {
                    throw (Throwable)new UnsupportedOperationException("Not yet implemented");
                }
                String string5 = string;
                Request modifiedRequest = builder.addHeader(string4, String.valueOf(string5)).build();
                return chain.proceed(modifiedRequest);
            }
            Request modifiedRequest = request.newBuilder().addHeader("Authorization", token).build();
            return chain.proceed(modifiedRequest);
        }
        catch (Exception e) {
            throw (Throwable)new IOException(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void refreshToken(Interceptor.Chain chain) {
        Response response = chain.proceed(RefreshToken.INSTANCE.getRequest());
        if (response.code() != 200) throw (Throwable)new RefreshTokenException("Response code: " + response.code() + ", message: " + response.message());
        if (response.body() == null) throw (Throwable)new RefreshTokenException("Response body: " + response.body());
        Gson gson = new Gson();
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            Intrinsics.throwNpe();
        }
        Object object = gson.fromJson(responseBody.string(), new TypeToken<Map<String, ? extends Object>>(){}.getType());
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Gson().fromJson(\n       \u2026ype\n                    )");
        Map refreshTokenResponse2 = (Map)object;
        if (refreshTokenResponse2.get("data") != null) {
            Object v = refreshTokenResponse2.get("data");
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, java.lang.Object>");
            }
            this.updateToken((Map)v);
            return;
        } else if (refreshTokenResponse2.get("datas") != null) {
            Object v = refreshTokenResponse2.get("datas");
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, java.lang.Object>");
            }
            this.updateToken((Map)v);
            return;
        } else {
            if (refreshTokenResponse2 == null) throw (Throwable)new CannotMapResponseToObject();
            this.updateToken(refreshTokenResponse2);
        }
    }

    private final void updateToken(Map<String, ? extends Object> data) {
        if (data.get(RefreshToken.INSTANCE.getAccessTokenKey()) != null && data.get(RefreshToken.INSTANCE.getRefreshTokenKey()) != null && data.get(RefreshToken.INSTANCE.getAccessValidKey()) != null && data.get(RefreshToken.INSTANCE.getRefreshValidKey()) != null) {
            Object object = data.get(RefreshToken.INSTANCE.getAccessValidKey());
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Double");
            }
            Object object2 = data.get(RefreshToken.INSTANCE.getRefreshValidKey());
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Double");
            }
            RefreshToken.INSTANCE.updateToken(String.valueOf(data.get(RefreshToken.INSTANCE.getAccessTokenKey())), String.valueOf(data.get(RefreshToken.INSTANCE.getRefreshTokenKey())), (long)((Double)object).doubleValue(), (long)((Double)object2).doubleValue());
        }
    }

    public ExpiredTokenInterceptor(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

