/*
 * Decompiled with CFR 0.152.
 */
package com.natradac.android.tokeninterceptor;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.natradac.android.tokeninterceptor.db.PreferenceHelper;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\u0006J\u0006\u0010\b\u001a\u00020\u0006J\u0006\u0010\t\u001a\u00020\u0006J\u0006\u0010\n\u001a\u00020\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0004J\u001e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/natradac/android/tokeninterceptor/RefreshToken;", "", "()V", "mContext", "Landroid/content/Context;", "mEndpoint", "", "getEndpoint", "getExpiresIn", "getTimeStamp", "getToken", "initEndpoint", "", "endpoint", "context", "updateToken", "token", "refreshToken", "expires_in", "", "TokenInterceptor_release"})
public final class RefreshToken {
    private static String mEndpoint;
    private static Context mContext;
    public static final RefreshToken INSTANCE;

    public final void initEndpoint(@NotNull String endpoint, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)endpoint, (String)"endpoint");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        mEndpoint = endpoint;
        mContext = context;
    }

    @NotNull
    public final String getEndpoint() {
        String string = mEndpoint;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mEndpoint");
        }
        return string;
    }

    public final void updateToken(@NotNull String token, @NotNull String refreshToken, long expires_in) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)refreshToken, (String)"refreshToken");
        Context context = mContext;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mContext");
        }
        SharedPreferences pref = PreferenceHelper.INSTANCE.defaultPrefs(context);
        PreferenceHelper.INSTANCE.set(pref, "TOKEN", token);
        PreferenceHelper.INSTANCE.set(pref, "REFRESH_TOKEN", refreshToken);
        PreferenceHelper.INSTANCE.set(pref, "EXPIRED_IN", expires_in);
        if (Build.VERSION.SDK_INT >= 26) {
            Instant instant = Instant.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.now()");
            l = instant.getEpochSecond();
        } else {
            l = System.currentTimeMillis() / 1000L;
        }
        PreferenceHelper.INSTANCE.set(pref, "TIME_STAMP", l);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getToken() {
        String string;
        void key$iv;
        void $this$get$iv;
        Context context = mContext;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mContext");
        }
        SharedPreferences sharedPreferences = PreferenceHelper.INSTANCE.defaultPrefs(context);
        PreferenceHelper preferenceHelper = PreferenceHelper.INSTANCE;
        String string2 = "TOKEN";
        String defaultValue$iv = "";
        boolean $i$f$get = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(String.class);
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            string = $this$get$iv.getString((String)key$iv, defaultValue$iv);
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            String string3 = defaultValue$iv;
            if (!(string3 instanceof Integer)) {
                string3 = null;
            }
            Integer n = (Integer)((Object)string3);
            string = (String)((Object)Integer.valueOf($this$get$iv.getInt((String)key$iv, n != null ? n : -1)));
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            String string4 = defaultValue$iv;
            if (!(string4 instanceof Boolean)) {
                string4 = null;
            }
            Boolean bl = (Boolean)((Object)string4);
            string = (String)((Object)Boolean.valueOf($this$get$iv.getBoolean((String)key$iv, bl != null ? bl : false)));
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            String string5 = defaultValue$iv;
            if (!(string5 instanceof Float)) {
                string5 = null;
            }
            Float f = (Float)((Object)string5);
            string = (String)((Object)Float.valueOf($this$get$iv.getFloat((String)key$iv, f != null ? f.floatValue() : -1.0f)));
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            String string6 = defaultValue$iv;
            if (!(string6 instanceof Long)) {
                string6 = null;
            }
            Long l = (Long)((Object)string6);
            string = (String)((Object)Long.valueOf($this$get$iv.getLong((String)key$iv, l != null ? l : -1L)));
        } else {
            throw (Throwable)new UnsupportedOperationException("Not yet implemented");
        }
        return String.valueOf(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getTimeStamp() {
        Long l;
        void key$iv;
        void $this$get$iv;
        Context context = mContext;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mContext");
        }
        SharedPreferences sharedPreferences = PreferenceHelper.INSTANCE.defaultPrefs(context);
        PreferenceHelper preferenceHelper = PreferenceHelper.INSTANCE;
        String string = "TIME_STAMP";
        Long defaultValue$iv = 0L;
        boolean $i$f$get = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(Long.class);
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            Long l2 = defaultValue$iv;
            if (!(l2 instanceof String)) {
                l2 = null;
            }
            l = (Long)((Object)$this$get$iv.getString((String)key$iv, (String)((Object)l2)));
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            Long l3 = defaultValue$iv;
            if (!(l3 instanceof Integer)) {
                l3 = null;
            }
            Integer n = (Integer)((Object)l3);
            l = (Long)$this$get$iv.getInt((String)key$iv, n != null ? n : -1);
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            Long l4 = defaultValue$iv;
            if (!(l4 instanceof Boolean)) {
                l4 = null;
            }
            Boolean bl = (Boolean)((Object)l4);
            l = (Long)((Object)Boolean.valueOf($this$get$iv.getBoolean((String)key$iv, bl != null ? bl : false)));
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            Long l5 = defaultValue$iv;
            if (!(l5 instanceof Float)) {
                l5 = null;
            }
            Float f = (Float)((Object)l5);
            l = (Long)((Object)Float.valueOf($this$get$iv.getFloat((String)key$iv, f != null ? f.floatValue() : -1.0f)));
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            Long l6 = defaultValue$iv;
            l = $this$get$iv.getLong((String)key$iv, l6 != null ? l6 : -1L);
        } else {
            throw (Throwable)new UnsupportedOperationException("Not yet implemented");
        }
        return String.valueOf(l);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getExpiresIn() {
        Long l;
        void key$iv;
        void $this$get$iv;
        Context context = mContext;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mContext");
        }
        SharedPreferences sharedPreferences = PreferenceHelper.INSTANCE.defaultPrefs(context);
        PreferenceHelper preferenceHelper = PreferenceHelper.INSTANCE;
        String string = "EXPIRED_IN";
        Long defaultValue$iv = 0L;
        boolean $i$f$get = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(Long.class);
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            Long l2 = defaultValue$iv;
            if (!(l2 instanceof String)) {
                l2 = null;
            }
            l = (Long)((Object)$this$get$iv.getString((String)key$iv, (String)((Object)l2)));
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            Long l3 = defaultValue$iv;
            if (!(l3 instanceof Integer)) {
                l3 = null;
            }
            Integer n = (Integer)((Object)l3);
            l = (Long)$this$get$iv.getInt((String)key$iv, n != null ? n : -1);
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            Long l4 = defaultValue$iv;
            if (!(l4 instanceof Boolean)) {
                l4 = null;
            }
            Boolean bl = (Boolean)((Object)l4);
            l = (Long)((Object)Boolean.valueOf($this$get$iv.getBoolean((String)key$iv, bl != null ? bl : false)));
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            Long l5 = defaultValue$iv;
            if (!(l5 instanceof Float)) {
                l5 = null;
            }
            Float f = (Float)((Object)l5);
            l = (Long)((Object)Float.valueOf($this$get$iv.getFloat((String)key$iv, f != null ? f.floatValue() : -1.0f)));
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            Long l6 = defaultValue$iv;
            l = $this$get$iv.getLong((String)key$iv, l6 != null ? l6 : -1L);
        } else {
            throw (Throwable)new UnsupportedOperationException("Not yet implemented");
        }
        return String.valueOf(l);
    }

    private RefreshToken() {
    }

    static {
        RefreshToken refreshToken;
        INSTANCE = refreshToken = new RefreshToken();
    }
}

