/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.xml;

import com.ochafik.lang.SyntaxUtils;
import com.ochafik.xml.XMLUtils;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathUtils {
    public static Map<String, SoftReference<XPathExpression>> xPathExpressionsCache = new LinkedHashMap<String, SoftReference<XPathExpression>>();
    private static SoftReference<XPath> sharedXPath;

    public static XPath getSharedXPath() {
        XPath xPath = null;
        if (sharedXPath != null) {
            xPath = sharedXPath.get();
        }
        if (xPath == null) {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            xPath = xPathFactory.newXPath();
            sharedXPath = new SoftReference<XPath>(xPath);
        }
        return xPath;
    }

    public static List<Node> findNodesByXPath(String xPathString, Object source) throws XPathExpressionException {
        return XMLUtils.list((NodeList)XPathUtils.getXPathExpression(xPathString).evaluate(source, XPathConstants.NODESET));
    }

    public static Iterable<Node> findNodesIterableByXPath(String xPathString, Object source) throws XPathExpressionException {
        return SyntaxUtils.iterable((NodeList)XPathUtils.getXPathExpression(xPathString).evaluate(source, XPathConstants.NODESET));
    }

    public static Node findNodeByXPath(String xPathString, Object source) throws XPathExpressionException {
        NodeList list = (NodeList)XPathUtils.getXPathExpression(xPathString).evaluate(source, XPathConstants.NODESET);
        int len = list.getLength();
        return len == 0 ? null : list.item(0);
    }

    public static String findStringByXPath(String xPathString, Object source) throws XPathExpressionException {
        return (String)XPathUtils.getXPathExpression(xPathString).evaluate(source, XPathConstants.STRING);
    }

    public static XPathExpression getXPathExpression(String xPathString) throws XPathExpressionException {
        XPathExpression expression;
        SoftReference<XPathExpression> ref = xPathExpressionsCache.get(xPathString);
        XPathExpression xPathExpression = expression = ref == null ? null : ref.get();
        if (expression == null) {
            expression = XPathUtils.getSharedXPath().compile(xPathString);
            xPathExpressionsCache.put(xPathString, new SoftReference<XPathExpression>(expression));
        }
        return expression;
    }
}

