/*
 * BridJ - Dynamic and blazing-fast native interop for Java.
 * http://bridj.googlecode.com/
 *
 * Copyright (c) 2010-2013, Olivier Chafik (http://ochafik.com/)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Olivier Chafik nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY OLIVIER CHAFIK AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.bridj.jawt;

import org.bridj.Pointer;
import org.bridj.StructObject;
import org.bridj.ann.Field;
import org.bridj.ann.Library;

/**
 * <i>native declaration : jawt.h</i><br>
 * This file was autogenerated by <a
 * href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a
 * href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few
 * opensource projects.</a>.<br>
 * For help, please visit <a
 * href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a
 * href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("jawt")
public class JAWT_DrawingSurfaceInfo extends StructObject {

    /**
     * Pointer to the platform-specific information. This can be safely<br>
     * cast to a JAWT_Win32DrawingSurfaceInfo on Windows or a<br>
     * JAWT_X11DrawingSurfaceInfo on Solaris. See jawt_md.h for details.<br>
     * C type : void*
     */
    @Field(0)
    public Pointer platformInfo() {
        return this.io.getPointerField(this, 0);
    }

    /**
     * Cached pointer to the underlying drawing surface<br>
     * C type : jawt_DrawingSurface*
     */
    @Field(1)
    public Pointer ds() {
        return this.io.getPointerField(this, 1);
    }

    /**
     * Bounding rectangle of the drawing surface<br>
     * C type : JAWT_Rectangle
     */
    @Field(2)
    public org.bridj.jawt.JAWT_Rectangle bounds() {
        return this.io.getNativeObjectField(this, 2);
    }
    /// Number of rectangles in the clip

    @Field(3)
    public int clipSize() {
        return this.io.getIntField(this, 3);
    }

    /**
     * Clip rectangle array<br>
     * C type : JAWT_Rectangle*
     */
    @Field(4)
    public org.bridj.jawt.JAWT_Rectangle clip() {
        return this.io.getNativeObjectField(this, 4);
    }
}
