/*
 * Decompiled with CFR 0.152.
 */
package com.nanorep.nanoclient.Channeling;

import com.nanorep.nanoclient.Channeling.NRChannelingChatForm;
import com.nanorep.nanoclient.Channeling.NRChannelingContactForm;
import com.nanorep.nanoclient.Channeling.NRChannelingCustomScript;
import com.nanorep.nanoclient.Channeling.NRChannelingOpenCustomURL;
import com.nanorep.nanoclient.Channeling.NRChannelingPhoneNumber;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class NRChanneling {
    protected String buttonText;
    protected String channelDescription;
    protected NRChannelingType type;
    protected NRQueryResult mQueryResult;
    protected HashMap<String, Object> mParams;
    private Map<String, String> extraData;
    private String noResultExtra;
    private String contactForm;
    private String iconUrl;
    protected int channelCode;
    protected String predefinedExtraData;

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String icon) {
        this.iconUrl = icon;
    }

    public String getName() {
        if (this.mParams != null && this.mParams.containsKey("name")) {
            return (String)this.mParams.get("name");
        }
        return "";
    }

    public String getThankYouMessage() {
        if (this.mParams != null && this.mParams.containsKey("thankYouMessage")) {
            return (String)this.mParams.get("thankYouMessage");
        }
        return "";
    }

    public int getChannelCode() {
        return this.channelCode;
    }

    public void setExtraData(Map<String, String> extraData, String predefinedExtraData) {
        this.extraData = extraData;
        this.predefinedExtraData = predefinedExtraData;
    }

    public JSONObject getExtraData() {
        JSONObject extraDataJson = null;
        try {
            if (this.predefinedExtraData != null) {
                extraDataJson = new JSONObject(this.predefinedExtraData);
            }
            if (this.extraData != null && !this.extraData.entrySet().isEmpty()) {
                if (extraDataJson == null) {
                    extraDataJson = new JSONObject();
                }
                for (Map.Entry<String, String> entry : this.extraData.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (key.isEmpty() || value.isEmpty()) continue;
                    extraDataJson.put(entry.getKey(), (Object)entry.getValue());
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (extraDataJson != null && !extraDataJson.toString().isEmpty()) {
            return extraDataJson;
        }
        return null;
    }

    public String getContactForm() {
        return this.contactForm;
    }

    public void setNoResultExtra(String noResultExtra) {
        this.noResultExtra = noResultExtra;
    }

    public String getNoResultExtra() {
        return this.noResultExtra;
    }

    public NRChanneling(HashMap<String, ?> params) {
        this.mParams = params;
        this.buttonText = this.value("buttonText");
        this.channelDescription = this.value("description");
        this.contactForm = this.value("contactForms");
        this.iconUrl = this.value("icon");
    }

    public NRChanneling(HashMap<String, ?> params, int channelCode) {
        this(params);
        this.channelCode = channelCode;
    }

    protected String value(String key) {
        if (key != null) {
            return (String)this.mParams.get(key);
        }
        return null;
    }

    protected Boolean booleanValue(String key) {
        if (key != null) {
            return (Boolean)this.mParams.get(key);
        }
        return null;
    }

    public String getButtonText() {
        return this.buttonText;
    }

    public String getChannelDescription() {
        return this.channelDescription;
    }

    public NRChannelingType getType() {
        return this.type;
    }

    public void setQueryResult(NRQueryResult queryResult) {
        this.mQueryResult = queryResult;
    }

    public NRQueryResult getQueryResult() {
        return this.mQueryResult;
    }

    public static NRChanneling channelForParams(HashMap<String, Object> params) {
        String actionEsc = (String)params.get("actionEsc");
        if (actionEsc != null) {
            switch (Integer.valueOf(actionEsc)) {
                case 1: {
                    return new NRChannelingOpenCustomURL(params);
                }
                case 2: {
                    return new NRChannelingCustomScript(params);
                }
                case 0: {
                    String channelCode = (String)params.get("channel");
                    if (channelCode == null) break;
                    switch (Integer.valueOf(channelCode)) {
                        case 5: {
                            return new NRChannelingPhoneNumber(params, 5);
                        }
                        case 3: {
                            return new NRChannelingChatForm(params, 3);
                        }
                        case 1: {
                            return new NRChannelingContactForm(params, 1);
                        }
                    }
                }
            }
        }
        return null;
    }

    public static enum NRChannelingType {
        PhoneNumber,
        OpenCustomURL,
        CustomScript,
        ContactForm,
        ChatForm;

    }
}

