package com.nanorep.nanoclient.network;

import android.net.Uri;
import android.os.AsyncTask;

import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.exception.NRConnectionException;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class SupportHttpTask extends AsyncTask<Void, Void, byte[]> {

    private SupportHttpResponseByte listener;
    private URL url;

    public SupportHttpTask(String strUrl, SupportHttpResponseByte listener) {
        this.listener = listener;
        try {
            url = new URL(strUrl);
        } catch (MalformedURLException e) {
            listener.error(new NRConnectionException(e.getMessage()));
        }
    }

    public SupportHttpTask(Uri uri, SupportHttpResponseByte listener) {
        this.listener = listener;
        try {
            url = new URL(uri.toString());
        } catch (MalformedURLException e) {
            listener.error(new NRConnectionException(e.getMessage()));
        }
    }

    protected byte[] doInBackground(Void... v) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            HttpURLConnection httpConnection = (HttpURLConnection) url.openConnection();
            httpConnection.setRequestMethod("GET");

            if (Nanorep.isInitialized() && Nanorep.getInstance().getHttpRequestTimeout() != 0) {
                httpConnection.setConnectTimeout(Nanorep.getInstance().getHttpRequestTimeout() * 1000);
            }

            InputStream inputStream = httpConnection.getInputStream();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

            byte[] buffer = new byte[1024];
            int bytesRead;

            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }

            inputStream.close();
            httpConnection.disconnect();
            return outputStream.toByteArray();

        } catch (NullPointerException | IOException e){
            listener.error(new NRConnectionException(e.getMessage()));
            return null;
        }
    }

    @Override
    protected void onPostExecute(byte[] response) {

        if (response == null) {
            listener.error(new NRConnectionException("null response"));
            return;
        }
        listener.success(response);

    }
}