package com.nanorep.nanoclient.Response;

import android.support.annotation.NonNull;
import android.util.Xml;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Pattern;

/**
 * Created by nissimpardo on 15/08/2016.
 */

public class NRHtmlParser {
    private String mHtmlString;
    public static final String LinkedArticle = "nanoreplinkid";
    private static String JavascriptTag = "javascript:void(0)";

    public NRHtmlParser(@NonNull String htmlString) {
        mHtmlString = htmlString;
    }

    public String getParsedHtml() {
        XmlPullParserFactory pullParserFactory;

        try {
            // Because we don't want to change the original text , only Identify its tags:
            String htmlStringCopy = String.copyValueOf(mHtmlString.toCharArray());

            // Because the "nbsp" tag fails the rest of the tags identification
            htmlStringCopy = htmlStringCopy.replace("&nbsp;", "");

            pullParserFactory = XmlPullParserFactory.newInstance();
            XmlPullParser parser = pullParserFactory.newPullParser();
            parser.setFeature(XmlPullParser.FEATURE_PROCESS_NAMESPACES, false);
            parser.setInput(new StringReader(htmlStringCopy));
            parser.setFeature(Xml.FEATURE_RELAXED, true);
            return parseHtml(parser);
        } catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String parseHtml(XmlPullParser parser) {

        try {
            int eventType = parser.getEventType();
            while (eventType != XmlPullParser.END_DOCUMENT) {

                if (eventType == XmlPullParser.START_TAG) {
                    if (parser.getName().equalsIgnoreCase("a")) {
                        if (parser.getAttributeCount() > 1) {
                            String atr0 = parser.getAttributeValue(null, "href");
                            String atr1 = parser.getAttributeValue(null, LinkedArticle);
                            if (atr0.equals(JavascriptTag) && atr1.matches("[0-9]+") && atr1.length() > 2) {
                                mHtmlString = mHtmlString.replaceFirst(Pattern.quote('\"' + atr0 + '\"'), LinkedArticle + "://" + atr1);
                            }
                        }
                    }
                }
                eventType = parser.next();

            }
        } catch (XmlPullParserException | IOException e) {
            e.printStackTrace();
        }
        return mHtmlString;
    }

    private String getValue(String attribute, XmlPullParser parser) {
        for (int i = 0; i < parser.getAttributeCount(); i++) {
            if (parser.getAttributeName(i).equals(attribute)) {
                return parser.getAttributeValue(i);
            }
        }
        return null;
    }
}
