/*
 * Decompiled with CFR 0.152.
 */
package com.nanorep.nanoclient.Response;

import android.util.Xml;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Pattern;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class NRHtmlParser {
    private String mHtmlString;

    public NRHtmlParser(String htmlString) {
        this.mHtmlString = htmlString;
    }

    public String getParsedHtml() {
        try {
            XmlPullParserFactory pullParserFactory = XmlPullParserFactory.newInstance();
            XmlPullParser parser = pullParserFactory.newPullParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            parser.setInput((Reader)new StringReader(this.mHtmlString));
            parser.setFeature(Xml.FEATURE_RELAXED, true);
            return this.parseHtml(parser);
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String parseHtml(XmlPullParser parser) {
        this.mHtmlString = this.mHtmlString.replace("&nbsp;", "");
        try {
            int eventType = parser.getEventType();
            while (eventType != 1) {
                switch (eventType) {
                    case 2: {
                        if (!parser.getName().equalsIgnoreCase("a") || parser.getAttributeCount() != 2 || !parser.getAttributeValue(0).equals("javascript:void(0)")) break;
                        this.mHtmlString = this.mHtmlString.replaceFirst(Pattern.quote("javascript:void(0)"), "nanorep://" + parser.getAttributeValue(1));
                    }
                }
                eventType = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.mHtmlString;
    }

    private String getValue(String attribute, XmlPullParser parser) {
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if (!parser.getAttributeName(i).equals(attribute)) continue;
            return parser.getAttributeValue(i);
        }
        return null;
    }
}

