package com.nanorep.nanoclient.model;


import com.nanorep.nanoclient.Interfaces.NRQueryResult;

import org.jetbrains.annotations.Nullable;

import java.util.Map;

/**
 * Created by nissimpardo on 04/06/16.
 */
public class NRResult implements ResultResponse {
    private Map<String, Object> params;
    private NRQueryResult mFetchedResult;
    private boolean mIsUnfolded = false;
    private RowType mRowType;
    private int mHeight;
    private boolean mIsSingle;

    @Override
    public boolean getShouldPresent() {
        return true;
    }

    @Override
    public int getResponseType() {
        return ResultResponseKt.faqType;
    }

    @Nullable
    @Override
    public String getResponseId() {
        return mFetchedResult.getId();
    }

    public enum RowType {
        TITLE, CONTENT, LIKE, CHANNELING
    }

    public NRResult(NRQueryResult result, RowType rowType) {
        mFetchedResult = result;
        mRowType = RowType.TITLE;
    }

    public Map<String, Object> getParams() {
        return params;
    }

    public NRResult(Map<String, Object> params) {
        this.params = params;
    }

    public NRQueryResult getFetchedResult() {
        return mFetchedResult;
    }

    public void setFetchedResult(NRQueryResult fetchedResult) {
        mFetchedResult = fetchedResult;
    }

    public boolean isUnfolded() {
        return mIsUnfolded;
    }

    public void setUnfolded(boolean unfolded) {
        mIsUnfolded = unfolded;
    }

    public RowType getRowType() {
        return mRowType;
    }

    public void setRowType(RowType rowType) {
        mRowType = rowType;
    }

    public int getHeight() {
        return mHeight;
    }

    public void setHeight(int height) {
        mHeight = height;
    }

    public boolean isSingle() {
        return mIsSingle;
    }

    public void setSingle(boolean single) {
        mIsSingle = single;
    }

}
