package com.nanorep.nanoclient

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Context.CONNECTIVITY_SERVICE
import android.content.Intent
import android.content.IntentFilter
import android.net.ConnectivityManager

fun hasNetworkConnection(context: Context) =
        (context.getSystemService(CONNECTIVITY_SERVICE) as ConnectivityManager).activeNetworkInfo?.isConnected
                ?: false

class ConnectivityReceiver : BroadcastReceiver() {

    private var listener: ConnectivityListener? = null
    var isConnected: Boolean = false
        private set
    private var isRegistered = false

    interface ConnectivityListener {
        fun connectionChanged(isConnected: Boolean)
    }

    fun register(context: Context?, listener: ConnectivityListener) {
        if (context == null) return

        val filter = IntentFilter(ConnectivityManager.CONNECTIVITY_ACTION)
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE")
        filter.addAction("android.net.wifi.WIFI_STATE_CHANGED")

        if(!isRegistered) {
            context.registerReceiver(this, filter)
            isRegistered = true
        }
        this.listener = listener
    }

    fun unregister(context: Context?) {
        if (context == null || !isRegistered) return

        context.unregisterReceiver(this)
        isRegistered = false
        listener = null
    }


    override fun onReceive(context: Context, intent: Intent) {
        val status = this.isConnected

        val connectivityManager = context.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
        if (connectivityManager != null) {
            val activeNetworkInfo = connectivityManager.activeNetworkInfo

            isConnected = activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting
        }

        if (status != isConnected && listener != null) {
            listener!!.connectionChanged(isConnected)
        }
    }
}
