package com.nanorep.nanoclient.Connection

import android.net.Uri
import com.nanorep.nanoclient.exception.NRConnectionException
import com.nanorep.nanoclient.network.OnDataResponse
import com.nanorep.nanoclient.network.SupportHttpResponseByte
import com.nanorep.nanoclient.network.SupportHttpTask


interface Decoder<T>{
    fun decode(value: T) : ByteArray
}

class SupportDownloader {

    companion object {

        fun <T> download(uri: Uri, mListener: OnDataResponse<T>, decoder: ((response: ByteArray) -> T)? = null) {

            SupportHttpTask(uri, object : SupportHttpResponseByte {

                override fun success(response: ByteArray) {
                    mListener.onSuccess(decoder?.invoke(response))
                }

                override fun error(error: NRConnectionException?) {
                    mListener.onError(error)
                }

            }).execute()
        }
    }
}
