package com.nanorep.nanoclient.network;

import android.net.Uri;
import android.os.AsyncTask;
import android.util.Log;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

/**
 * Created by Aviran Abady on 4/24/17.
 */

public class GetBinaryHttpTask extends AsyncTask<Void, Void, ByteArrayOutputStream> {

    public interface HttpBinaryResponse {
        void success(byte[] response);
        void error();
    }

    private HttpBinaryResponse responseListener;
    private URL url;

    public GetBinaryHttpTask( String strUrl, HttpBinaryResponse listener) {
        this.responseListener = listener;
        try {
            url = new URL(strUrl);
        } catch (MalformedURLException e) {
            listener.error();
        }
    }

    public GetBinaryHttpTask(Uri uri, HttpBinaryResponse listener) {
        this.responseListener = listener;
        try {
            url = new URL(uri.toString());
        } catch (MalformedURLException e) {
            listener.error();
        }
    }

    protected ByteArrayOutputStream doInBackground(Void... v) {
        try {

            Log.i("image fetch", "start - " + url);
            HttpURLConnection httpConnection = (HttpURLConnection) url.openConnection();
            httpConnection.setRequestMethod("GET");
            InputStream inputStream = httpConnection.getInputStream();
//            InputStreamReader reader = new InputStreamReader(inputStream);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();


            byte[] buffer = new byte[1024];
            int charsRead;
            while ((charsRead = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, charsRead);
            }

            inputStream.close();
            httpConnection.disconnect();
            Log.i("image fetch", "end   - " + url);
            return bos;
        } catch (MalformedURLException | NullPointerException e) {
            return null;
        } catch (ProtocolException e) {
            return null;
        } catch (IOException e) {
            return null;
        }
    }

    protected void onPostExecute(ByteArrayOutputStream response) {
        if (response == null) {
            responseListener.error();
            return;
        }
        responseListener.success(response.toByteArray());

        try {
            response.close();
        } catch (IOException e) {

        }
    }
}