/*
 * Decompiled with CFR 0.152.
 */
package com.nanorep.nanoclient.Response;

import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Response.NRQueryResultBody;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NRAnswer
implements NRQueryResult {
    private HashMap<String, Object> mParams;
    private String mArticleId;
    private String mKeywordsetId;
    private int mLikes;
    private String mTitle;
    private NRQueryResultBody mBody;
    private NRQueryResult.LikeState mLikeState = NRQueryResult.LikeState.notSelected;
    private List<NRChanneling> mChanneling;
    private boolean mIsCNF = false;

    public NRAnswer(HashMap<String, Object> params) {
        if (params != null) {
            this.mParams = params;
            this.mArticleId = (String)params.get("id");
            this.mKeywordsetId = (String)params.get("keywordsetId");
            this.mLikes = (Integer)params.get("likes");
            this.mTitle = (String)params.get("title");
            this.mBody = new NRQueryResultBody((String)params.get("summary"));
        }
    }

    public String getArticleId() {
        return this.mArticleId;
    }

    public String getKeywordsetId() {
        return this.mKeywordsetId;
    }

    @Override
    public String getLikes() {
        return Integer.toString(this.mLikes);
    }

    @Override
    public String getBody() {
        return this.mBody.getBody();
    }

    @Override
    public String getId() {
        return this.getArticleId();
    }

    @Override
    public String getTitle() {
        return this.mTitle;
    }

    @Override
    public void setBody(String body) {
        this.mBody = new NRQueryResultBody(body);
    }

    @Override
    public void setLikeState(NRQueryResult.LikeState likeState) {
        this.mLikeState = likeState;
    }

    @Override
    public NRQueryResult.LikeState getLikeState() {
        return this.mLikeState;
    }

    @Override
    public Integer getHash() {
        return (Integer)this.mParams.get("titleAndBodyHash");
    }

    @Override
    public HashMap<String, Object> getParams() {
        return this.mParams;
    }

    @Override
    public boolean isCNF() {
        return this.mIsCNF;
    }

    @Override
    public List<NRChanneling> getChanneling() {
        if (this.mChanneling == null) {
            ArrayList channels = (ArrayList)this.mParams.get("rechanneling");
            if (channels != null && channels.size() > 0) {
                this.mChanneling = new ArrayList<NRChanneling>();
                for (HashMap channel : channels) {
                    this.mChanneling.add(NRChanneling.channelForParams(channel));
                }
            } else {
                return null;
            }
        }
        return this.mChanneling;
    }

    @Override
    public String getKeywordSetId() {
        return this.mKeywordsetId;
    }

    @Override
    public void setIsCNF(boolean isCNF) {
        this.mIsCNF = isCNF;
    }

    @Override
    public void setChanneling(ArrayList<NRChanneling> channeling) {
        this.mChanneling = channeling;
    }

    @Override
    public String getExtraData() {
        return this.mBody.getExtraData();
    }
}

