/*
 * Decompiled with CFR 0.152.
 */
package com.nanorep.nanoclient;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0011\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rR\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/nanorep/nanoclient/ConnectivityReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "<set-?>", "", "isConnected", "()Z", "isRegistered", "listener", "Lcom/nanorep/nanoclient/ConnectivityReceiver$ConnectivityListener;", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "register", "unregister", "ConnectivityListener", "engine_release"})
public final class ConnectivityReceiver
extends BroadcastReceiver {
    private ConnectivityListener listener;
    private boolean isConnected;
    private boolean isRegistered;

    public final boolean isConnected() {
        return this.isConnected;
    }

    public final void register(@Nullable Context context, @NotNull ConnectivityListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        if (context == null) {
            return;
        }
        IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        filter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        if (!this.isRegistered) {
            context.registerReceiver((BroadcastReceiver)this, filter);
            this.isRegistered = true;
        }
        this.listener = listener;
    }

    public final void unregister(@Nullable Context context) {
        if (context == null || !this.isRegistered) {
            return;
        }
        context.unregisterReceiver((BroadcastReceiver)this);
        this.isRegistered = false;
        this.listener = null;
    }

    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        boolean status = this.isConnected;
        Object object = context.getSystemService("connectivity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)object;
        if (connectivityManager != null) {
            NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
            boolean bl = this.isConnected = activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting();
        }
        if (status != this.isConnected && this.listener != null) {
            ConnectivityListener connectivityListener = this.listener;
            if (connectivityListener == null) {
                Intrinsics.throwNpe();
            }
            connectivityListener.connectionChanged(this.isConnected);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/nanorep/nanoclient/ConnectivityReceiver$ConnectivityListener;", "", "connectionChanged", "", "isConnected", "", "engine_release"})
    public static interface ConnectivityListener {
        public void connectionChanged(boolean var1);
    }
}

