package com.nanorep.nanoclient.Handlers;

import com.nanorep.nanoclient.Connection.NRDownloader;

import static com.nanorep.nanoclient.Connection.NRErrorCodes.CONNECTION;

/**
 * Created by noat on 15/11/2016.
 */

public class NRErrorHandler {

    private static NRErrorHandler instance;



    public enum ErrorType {
        TIMEOUT_UPPER_LINE
    }

    private Listener listener;

    public interface Listener {
        void showConnectionError(ErrorType errorType);
        void dismissConnectionError();
    }

    public static NRErrorHandler getInstance() {
        if(instance == null) {
            synchronized (NRErrorHandler.class) {
                if(instance == null) {
                    instance = new NRErrorHandler();
                }
            }
        }
        return instance;
    }

    public void handleError(int code) {

        if(listener == null) {
            return;
        }

        switch (code) {
            case NRDownloader.TIMEOUT: // timeout
            case CONNECTION: // timeout
                listener.showConnectionError(ErrorType.TIMEOUT_UPPER_LINE);
                break;
        }
    }

    public void reset() {

        if(listener == null) {
            return;
        }

        listener.dismissConnectionError();
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }
}
